/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;

public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    int array_offset = 0;
    char[] backing_buffer;

    public static CharBuffer allocate(int capacity) {
        return new CharBufferImpl(capacity);
    }

    public static final CharBuffer wrap(char[] array, int offset, int length) {
        return new CharBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final CharBuffer wrap(CharSequence seq) {
        return CharBuffer.wrap(seq, 0, seq.length());
    }

    public static final CharBuffer wrap(CharSequence seq, int start, int end) {
        if (start < 0 || start > seq.length() || end < start || end > seq.length() - start) {
            throw new IndexOutOfBoundsException();
        }
        int len = end - start;
        char[] buffer = new char[len];
        int i = 0;
        while (i < len) {
            buffer[i] = seq.charAt(i + start);
            ++i;
        }
        return CharBuffer.wrap(buffer, 0, len).asReadOnlyBuffer();
    }

    public static final CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    public CharBuffer get(char[] dst, int offset, int length) {
        CharBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            char[] toPut = new char[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        CharBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = this.get(this.position()) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharBuffer) {
            boolean bl = false;
            if (this.compareTo(obj) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object obj) {
        CharBuffer other = (CharBuffer)obj;
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            char b;
            char a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] buf = new char[this.length()];
        int pos = this.position();
        this.get(buf, 0, buf.length);
        this.position(pos);
        return new String(buf);
    }

    public final int length() {
        return this.remaining();
    }

    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String str, int start, int length) {
        return this.put(str.toCharArray(), start, length);
    }

    public final CharBuffer put(String str) {
        return this.put(str.toCharArray(), 0, str.length());
    }

    public final char charAt(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + index);
    }

    CharBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }
}

