;;; DO NOT MODIFY THIS FILE -*- coding: raw-text-unix -*-
;;;###coding system: raw-text-unix
(if (featurep 'mule-autoloads) (error "Feature mule-autoloads already loaded"))

;;;### (autoloads (check-ccl-program define-ccl-program declare-ccl-program ccl-dump ccl-compile) "ccl" "mule/ccl.el")

(autoload 'ccl-compile "ccl" "\
Return a compiled code of CCL-PROGRAM as a vector of integer.

arguments: (CCL-PROGRAM)
" nil nil)

(autoload 'ccl-dump "ccl" "\
Disassemble compiled CCL-CODE.

arguments: (CCL-CODE)
" nil nil)

(autoload 'declare-ccl-program "ccl" "\
Declare NAME as a name of CCL program.

This macro exists for backward compatibility.  In the old version of
Emacs, to compile a CCL program which calls another CCL program not
yet defined, it must be declared as a CCL program in advance.  But,
now CCL program names are resolved not at compile time but before
execution.

Optional arg VECTOR is a compiled CCL code of the CCL program.

arguments: (NAME &optional VECTOR)
" nil 'macro)

(autoload 'define-ccl-program "ccl" "\
Set NAME to be the compiled CCL code of CCL-PROGRAM.

CCL-PROGRAM has this form:
	(BUFFER_MAGNIFICATION
	 CCL_MAIN_CODE
	 [ CCL_EOF_CODE ])

BUFFER_MAGNIFICATION is an integer value specifying the approximate
output buffer magnification size compared with the bytes of input data
text.  If the value is zero, the CCL program can't execute `read' and
`write' commands.

CCL_MAIN_CODE and CCL_EOF_CODE are CCL program codes.  CCL_MAIN_CODE is
executed first.  If there are no more input data when a `read' command is
executed in CCL_MAIN_CODE, CCL_EOF_CODE is executed.  If CCL_MAIN_CODE is
terminated, CCL_EOF_CODE is not executed.

Here's the syntax of CCL program code in BNF notation.  The lines starting
with two semicolons (and optional leading spaces) describe the semantics.

CCL_MAIN_CODE := CCL_BLOCK

CCL_EOF_CODE := CCL_BLOCK

CCL_BLOCK := STATEMENT | (STATEMENT [STATEMENT ...])

STATEMENT :=
	SET | IF | BRANCH | LOOP | REPEAT | BREAK | READ | WRITE | CALL
	| TRANSLATE | MAP | LOOKUP | END

SET :=	(REG = EXPRESSION)
	| (REG ASSIGNMENT_OPERATOR EXPRESSION)
	;; The following form is the same as (r0 = INT-OR-CHAR).
	| INT-OR-CHAR

EXPRESSION := ARG | (EXPRESSION OPERATOR ARG)

;; Evaluate EXPRESSION.  If the result is nonzero, execute
;; CCL_BLOCK_0.  Otherwise, execute CCL_BLOCK_1.
IF :=	(if EXPRESSION CCL_BLOCK_0 [CCL_BLOCK_1])

;; Evaluate EXPRESSION.  Provided that the result is N, execute
;; CCL_BLOCK_N.
BRANCH := (branch EXPRESSION CCL_BLOCK_0 [CCL_BLOCK_1 ...])

;; Execute STATEMENTs until (break) or (end) is executed.
LOOP := (loop STATEMENT [STATEMENT ...])

;; Terminate the innermost loop.
BREAK := (break)

REPEAT :=
	;; Jump to the head of the innermost loop.
	(repeat)
	;; Same as: ((write [REG | INT-OR-CHAR | string])
	;;	     (repeat))
	| (write-repeat [REG | INT-OR-CHAR | string])
	;; Same as: ((write REG [ARRAY])
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG [ARRAY])
	;; Same as: ((write INT-OR-CHAR)
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG INT-OR-CHAR)

READ := ;; Set REG_0 to a byte read from the input text, set REG_1
	;; to the next byte read, and so on. Note that \"byte\" here means
	;; \"some octet from XEmacs' internal representation\", which may
	;; not be that useful to you when non-ASCII characters are involved.
        ;;
        ;; Yes, this is exactly the opposite of what (write ...) does.
	(read REG_0 [REG_1 ...])
	;; Same as: ((read REG)
	;;	     (if (REG OPERATOR ARG) CCL_BLOCK_0 CCL_BLOCK_1))
	| (read-if (REG OPERATOR ARG) CCL_BLOCK_0 [CCL_BLOCK_1])
	;; Same as: ((read REG)
	;;	     (branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...]))
	| (read-branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...])
	;; Read a character from the input text, splitting it into its
	;; multibyte representation. Set REG_0 to the charset ID of the
	;; character, and set REG_1 to the code point of the character.  If
	;; the dimension of charset is two, set REG_1 to ((CODE0 << 7) |
	;; CODE1), where CODE0 is the first code point and CODE1 is the
	;; second code point.
	| (read-multibyte-character REG_0 REG_1)

WRITE :=
	;; Write REG_0, REG_1, ... to the output buffer.  If REG_N is
	;; a multibyte character, write the corresponding multibyte
	;; representation.
	(write REG_0 [REG_1 ...])
	;; Same as: ((r7 = EXPRESSION)
	;;	     (write r7))
	| (write EXPRESSION)
	;; Write the value of `INT-OR-CHAR' to the output buffer.  If it
	;; is a multibyte character, write the corresponding multibyte
	;; representation.
	| (write INT-OR-CHAR)
	;; Write the byte sequence of `string' as is to the output
	;; buffer.  It is encoded by binary coding system, thus,
        ;; by this operation, you cannot write multibyte string
        ;; as it is.
	| (write string)
	;; Same as: (write string)
	| string
	;; Provided that the value of REG is N, write Nth element of
	;; ARRAY to the output buffer.  If it is a multibyte
	;; character, write the corresponding multibyte
	;; representation.
	| (write REG ARRAY)
	;; Write a multibyte representation of a character whose
	;; charset ID is REG_0 and code point is REG_1.  If the
	;; dimension of the charset is two, REG_1 should be ((CODE0 <<
	;; 7) | CODE1), where CODE0 is the first code point and CODE1
	;; is the second code point of the character.
	| (write-multibyte-character REG_0 REG_1)

;; Call CCL program whose name is ccl-program-name.
CALL := (call ccl-program-name)

TRANSLATE := ;; Not implemented under XEmacs, except mule-to-unicode and
	     ;; unicode-to-mule.
	     (translate-character REG(table) REG(charset) REG(codepoint)) 
	     | (translate-character SYMBOL REG(charset) REG(codepoint)) 
	     | (mule-to-unicode REG(charset) REG(codepoint))
	     | (unicode-to-mule REG(unicode,code) REG(CHARSET))

LOOKUP :=
	(lookup-character SYMBOL REG(charset) REG(codepoint))
	| (lookup-integer SYMBOL REG(integer))
        ;; SYMBOL refers to a table defined by `define-hash-translation-table'.

MAP :=
     (iterate-multiple-map REG REG MAP-IDs)
     | (map-multiple REG REG (MAP-SET))
     | (map-single REG REG MAP-ID)
MAP-IDs := MAP-ID ...
MAP-SET := MAP-IDs | (MAP-IDs) MAP-SET
MAP-ID := INT-OR-CHAR

;; Terminate the CCL program.
END := (end)

;; CCL registers. These can contain any integer value.  As r7 is used by the
;; CCL interpreter itself, its value can change unexpectedly.
REG := r0 | r1 | r2 | r3 | r4 | r5 | r6 | r7

ARG := REG | INT-OR-CHAR

OPERATOR :=
	;; Normal arithmetical operators (same meaning as C code).
	+ | - | * | / | %

	;; Bitwise operators (same meaning as C code)
	| & | `|' | ^

	;; Shifting operators (same meaning as C code)
	| << | >>

	;; (REG = ARG_0 <8 ARG_1) means:
	;;	(REG = ((ARG_0 << 8) | ARG_1))
	| <8

	;; (REG = ARG_0 >8 ARG_1) means:
	;;	((REG = (ARG_0 >> 8))
	;;	 (r7 = (ARG_0 & 255)))
	| >8

	;; (REG = ARG_0 // ARG_1) means:
	;;	((REG = (ARG_0 / ARG_1))
	;;	 (r7 = (ARG_0 % ARG_1)))
	| //

	;; Normal comparing operators (same meaning as C code)
	| < | > | == | <= | >= | !=

	;; If ARG_0 and ARG_1 are higher and lower byte of Shift-JIS
	;; code, and CHAR is the corresponding JISX0208 character,
	;; (REG = ARG_0 de-sjis ARG_1) means:
	;;	((REG = CODE0)
	;;	 (r7 = CODE1))
	;; where CODE0 is the first code point of CHAR, CODE1 is the
	;; second code point of CHAR.
	| de-sjis

	;; If ARG_0 and ARG_1 are the first and second code point of
	;; JISX0208 character CHAR, and SJIS is the corresponding
	;; Shift-JIS code,
	;; (REG = ARG_0 en-sjis ARG_1) means:
	;;	((REG = HIGH)
	;;	 (r7 = LOW))
	;; where HIGH is the higher byte of SJIS, LOW is the lower
	;; byte of SJIS.
	| en-sjis

ASSIGNMENT_OPERATOR :=
	;; Same meaning as C code
	+= | -= | *= | /= | %= | &= | `|=' | ^= | <<= | >>=

	;; (REG <8= ARG) is the same as:
	;;	((REG <<= 8)
	;;	 (REG |= ARG))
	| <8= 

	;; (REG >8= ARG) is the same as:
	;;	((r7 = (REG & 255))
	;;	 (REG >>= 8))

	;; (REG //= ARG) is the same as:
	;;	((r7 = (REG % ARG))
	;;	 (REG /= ARG))
	| //=

ARRAY := `[' INT-OR-CHAR ... `]'

INT-OR-CHAR := integer | character


arguments: (NAME CCL-PROGRAM &optional DOC)
" nil 'macro)

(autoload 'check-ccl-program "ccl" "\
Check validity of CCL-PROGRAM.
If CCL-PROGRAM is a symbol denoting a CCL program, return
CCL-PROGRAM, else return nil.
If CCL-PROGRAM is a vector and optional arg NAME (symbol) is supplied,
register CCL-PROGRAM by name NAME, and return NAME.

arguments: (CCL-PROGRAM &optional NAME)
" nil 'macro)

;;;***

;;;### (autoloads (encode-hz-buffer encode-hz-region decode-hz-buffer decode-hz-region) "china-util" "mule/china-util.el")

(autoload 'decode-hz-region "china-util" "\
Decode HZ/ZW encoded text in the current region.
Return the length of resulting text.

arguments: (BEG END)
" t nil)

(autoload 'decode-hz-buffer "china-util" "\
Decode HZ/ZW encoded text in the current buffer.

arguments: ()
" t nil)

(autoload 'encode-hz-region "china-util" "\
Encode the text in the current region to HZ.
Return the length of resulting text.

arguments: (BEG END)
" t nil)

(autoload 'encode-hz-buffer "china-util" "\
Encode the text in the current buffer to HZ.

arguments: ()
" t nil)

;;;***

;;;### (autoloads (set-compiled-unicode-file-search-table) "compiled-unicode-tables" "mule/compiled-unicode-tables.el")

(autoload 'set-compiled-unicode-file-search-table "compiled-unicode-tables" "\
Set the `compiled-unicode-file-search-table' variable used by
unicode.c:Fload_unicode_mapping_table(). The values are compiled into this
function, and after being called once, this function does nothing.


arguments: ()
" nil nil)

;;;***

;;;### (autoloads (devanagari-decode-itrans-region devanagari-encode-itrans-region in-is13194-devanagari-pre-write-conversion devanagari-decompose-to-is13194-region in-is13194-devanagari-post-read-conversion devanagari-compose-from-is13194-region devanagari-compose-region devanagari-compose-string devanagari-decompose-region devanagari-decompose-string char-to-glyph-devanagari indian-to-devanagari-string devanagari-to-indian-region indian-to-devanagari-region devanagari-to-indian indian-to-devanagari) "devan-util" "mule/devan-util.el")

(autoload 'indian-to-devanagari "devan-util" "\
Convert IS 13194 character CHAR to Devanagari basic characters.
If CHAR is not IS 13194, return CHAR as is.

arguments: (CHAR)
" nil nil)

(autoload 'devanagari-to-indian "devan-util" "\
Convert Devanagari basic character CHAR to IS 13194 characters.
If CHAR is not Devanagari basic character, return CHAR as is.

arguments: (CHAR)
" nil nil)

(autoload 'indian-to-devanagari-region "devan-util" "\
Convert IS 13194 characters in region to Devanagari basic characters.
When called from a program, expects two arguments,
positions (integers or markers) specifying the region.

arguments: (FROM TO)
" t nil)

(autoload 'devanagari-to-indian-region "devan-util" "\
Convert Devanagari basic characters in region to Indian characters.
When called from a program, expects two arguments,
positions (integers or markers) specifying the region.

arguments: (FROM TO)
" t nil)

(autoload 'indian-to-devanagari-string "devan-util" "\
Convert Indian characters in STRING to Devanagari Basic characters.

arguments: (STRING)
" nil nil)

(autoload 'char-to-glyph-devanagari "devan-util" "\
Convert Devanagari characters in STRING to Devanagari glyphs.  
Ligatures and special rules are processed.

arguments: (STRING &rest LANGS)
" nil nil)

(autoload 'devanagari-decompose-string "devan-util" "\
Decompose Devanagari string STR

arguments: (STR)
" nil nil)

(autoload 'devanagari-decompose-region "devan-util" "\


arguments: (FROM TO)
" t nil)

(autoload 'devanagari-compose-string "devan-util" "\


arguments: (STR &rest LANGS)
" nil nil)

(autoload 'devanagari-compose-region "devan-util" "\


arguments: (FROM TO &rest LANGS)
" t nil)

(autoload 'devanagari-compose-from-is13194-region "devan-util" "\
Compose IS 13194 characters in the region to Devanagari characters.

arguments: (FROM TO)
" t nil)

(autoload 'in-is13194-devanagari-post-read-conversion "devan-util" "\


arguments: (LEN)
" nil nil)

(autoload 'devanagari-decompose-to-is13194-region "devan-util" "\
Decompose Devanagari characters in the region to IS 13194 characters.

arguments: (FROM TO)
" t nil)

(autoload 'in-is13194-devanagari-pre-write-conversion "devan-util" "\


arguments: (FROM TO)
" nil nil)

(autoload 'devanagari-encode-itrans-region "devan-util" "\


arguments: (FROM TO)
" t nil)

(autoload 'devanagari-decode-itrans-region "devan-util" "\


arguments: (FROM TO)
" t nil)

;;;***

;;;### (autoloads (ethio-write-file ethio-find-file ethio-java-to-fidel-buffer ethio-fidel-to-java-buffer ethio-tex-to-fidel-buffer ethio-fidel-to-tex-buffer ethio-input-special-character ethio-replace-space ethio-modify-vowel ethio-fidel-to-sera-marker ethio-fidel-to-sera-mail ethio-fidel-to-sera-mail-or-marker ethio-fidel-to-sera-buffer ethio-fidel-to-sera-region ethio-sera-to-fidel-marker ethio-sera-to-fidel-mail ethio-sera-to-fidel-mail-or-marker ethio-sera-to-fidel-buffer ethio-sera-to-fidel-region setup-ethiopic-environment-internal) "ethio-util" "mule/ethio-util.el")

(autoload 'setup-ethiopic-environment-internal "ethio-util" "\


arguments: ()
" nil nil)

(autoload 'ethio-sera-to-fidel-region "ethio-util" "\
Convert the characters in region from SERA to FIDEL.
The variable `ethio-primary-language' specifies the primary language
and `ethio-secondary-language' specifies the secondary.

If the 3rd parameter SECONDARY is given and non-nil, assume the region
begins with the secondary language; otherwise with the primary
language.

If the 4th parameter FORCE is given and non-nil, perform conversion
even if the buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and
`ethio-use-three-dot-question'.

arguments: (BEG END &optional SECONDARY FORCE)
" t nil)

(autoload 'ethio-sera-to-fidel-buffer "ethio-util" "\
Convert the current buffer from SERA to FIDEL.

The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional parameter SECONDARY is non-nil, assume the buffer
begins with the secondary language; otherwise with the primary
language.

If the 2nd optional parametr FORCE is non-nil, perform conversion even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and
`ethio-use-three-dot-question'.

arguments: (&optional SECONDARY FORCE)
" t nil)

(autoload 'ethio-sera-to-fidel-mail-or-marker "ethio-util" "\
Execute ethio-sera-to-fidel-mail or ethio-sera-to-fidel-marker depending on the current major mode.
If in rmail-mode or in mail-mode, execute the former; otherwise latter.

arguments: (&optional ARG)
" t nil)

(autoload 'ethio-sera-to-fidel-mail "ethio-util" "\
Convert SERA to FIDEL to read/write mail and news.

If the buffer contains the markers \"<sera>\" and \"</sera>\",
convert the segments between them into FIDEL.

If invoked interactively and there is no marker, convert the subject field
and the body into FIDEL using `ethio-sera-to-fidel-region'.

arguments: (&optional ARG)
" t nil)

(autoload 'ethio-sera-to-fidel-marker "ethio-util" "\
Convert the regions surrounded by \"<sera>\" and \"</sera>\" from SERA to FIDEL.
Assume that each region begins with `ethio-primary-language'.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

arguments: (&optional FORCE)
" t nil)

(autoload 'ethio-fidel-to-sera-region "ethio-util" "\
Replace all the FIDEL characters in the region to the SERA format.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 3dr parameter SECONDARY is given and non-nil, try to convert
the region so that it begins in the secondary language; otherwise with
the primary language.

If the 4th parameter FORCE is given and non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

arguments: (BEGIN END &optional SECONDARY FORCE)
" t nil)

(autoload 'ethio-fidel-to-sera-buffer "ethio-util" "\
Replace all the FIDEL characters in the current buffer to the SERA format.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional parameter SECONDARY is non-nil, try to convert the
region so that it begins in the secondary language; otherwise with the
primary language.

If the 2nd optional parameter FORCE is non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

arguments: (&optional SECONDARY FORCE)
" t nil)

(autoload 'ethio-fidel-to-sera-mail-or-marker "ethio-util" "\
Execute ethio-fidel-to-sera-mail or ethio-fidel-to-sera-marker depending on the current major mode.
If in rmail-mode or in mail-mode, execute the former; otherwise latter.

arguments: (&optional ARG)
" t nil)

(autoload 'ethio-fidel-to-sera-mail "ethio-util" "\
Convert FIDEL to SERA to read/write mail and news.

If the body contains at least one Ethiopic character,
 1) insert the string \"<sera>\" at the beginning of the body,
 2) insert \"</sera>\" at the end of the body, and
 3) convert the body into SERA.

The very same procedure applies to the subject field, too.

arguments: ()
" t nil)

(autoload 'ethio-fidel-to-sera-marker "ethio-util" "\
Convert the regions surrounded by \"<sera>\" and \"</sera>\" from FIDEL to SERA.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

arguments: (&optional FORCE)
" t nil)

(autoload 'ethio-modify-vowel "ethio-util" "\
Modify the vowel of the FIDEL that is under the cursor.

arguments: ()
" t nil)

(autoload 'ethio-replace-space "ethio-util" "\
Replace ASCII spaces with Ethiopic word separators in the region.

In the specified region, replace word separators surrounded by two
Ethiopic characters, depending on the first parameter CH, which should
be 1, 2, or 3.

If CH = 1, word separator will be replaced with an ASCII space.
If CH = 2, with two ASCII spaces.
If CH = 3, with the Ethiopic colon-like word separator.

The second and third parameters BEGIN and END specify the region.

arguments: (CH BEGIN END)
" t nil)

(autoload 'ethio-input-special-character "ethio-util" "\
Allow the user to input special characters.

arguments: (ARG)
" t nil)

(autoload 'ethio-fidel-to-tex-buffer "ethio-util" "\
Convert each fidel characters in the current buffer into a fidel-tex command.
Each command is always surrounded by braces.

arguments: ()
" t nil)

(autoload 'ethio-tex-to-fidel-buffer "ethio-util" "\
Convert fidel-tex commands in the current buffer into fidel chars.

arguments: ()
" t nil)

(autoload 'ethio-fidel-to-java-buffer "ethio-util" "\
Convert Ethiopic characters into the Java escape sequences.

Each escape sequence is of the form \\uXXXX, where XXXX is the
character's codepoint (in hex) in Unicode.

If `ethio-java-save-lowercase' is non-nil, use [0-9a-f].
Otherwise, [0-9A-F].

arguments: ()
" nil nil)

(autoload 'ethio-java-to-fidel-buffer "ethio-util" "\
Convert the Java escape sequences into corresponding Ethiopic characters.

arguments: ()
" nil nil)

(autoload 'ethio-find-file "ethio-util" "\
Transcribe file content into Ethiopic dependig on filename suffix.

arguments: ()
" nil nil)

(autoload 'ethio-write-file "ethio-util" "\
Transcribe Ethiopic characters in ASCII depending on the file extension.

arguments: ()
" nil nil)

;;;***

;;;### (autoloads ('arabic-iso-8bit-with-esc 'greek-iso-8bit-with-esc 'hebrew-iso-8bit-with-esc 'cyrillic-iso-8bit-with-esc 'iso-latin-5-with-esc 'iso-latin-9-with-esc 'iso-latin-4-with-esc 'iso-latin-3-with-esc 'iso-latin-2-with-esc) "iso-with-esc" "mule/iso-with-esc.el")

(define-coding-system-alias 'iso-latin-1-with-esc 'iso-2022-8)

(autoload-coding-system 'iso-latin-2-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'iso-latin-3-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'iso-latin-4-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'iso-latin-9-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'iso-latin-5-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'cyrillic-iso-8bit-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'hebrew-iso-8bit-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'greek-iso-8bit-with-esc '(load "iso-with-esc"))

(autoload-coding-system 'arabic-iso-8bit-with-esc '(load "iso-with-esc"))

;;;***

;;;### (autoloads (read-hiragana-string japanese-zenkaku-region japanese-hankaku-region japanese-hiragana-region japanese-katakana-region japanese-zenkaku japanese-hankaku japanese-hiragana japanese-katakana setup-japanese-environment-internal) "japan-util" "mule/japan-util.el")

(autoload 'setup-japanese-environment-internal "japan-util" "\


arguments: ()
" nil nil)

(autoload 'japanese-katakana "japan-util" "\
Convert argument to Katakana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument HANKAKU t means to convert to `hankaku' Katakana
 (`japanese-jisx0201-kana'), in which case return value
 may be a string even if OBJ is a character if two Katakanas are
 necessary to represent OBJ.

arguments: (OBJ &optional HANKAKU)
" nil nil)

(autoload 'japanese-hiragana "japan-util" "\
Convert argument to Hiragana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

arguments: (OBJ)
" nil nil)

(autoload 'japanese-hankaku "japan-util" "\
Convert argument to `hankaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument ASCII-ONLY non-nil means to return only ASCII character.

arguments: (OBJ &optional ASCII-ONLY)
" nil nil)

(autoload 'japanese-zenkaku "japan-util" "\
Convert argument to `zenkaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

arguments: (OBJ)
" nil nil)

(autoload 'japanese-katakana-region "japan-util" "\
Convert Japanese `hiragana' chars in the region to `katakana' chars.
Optional argument HANKAKU t means to convert to `hankaku katakana' character
of which charset is `japanese-jisx0201-kana'.

arguments: (FROM TO &optional HANKAKU)
" t nil)

(autoload 'japanese-hiragana-region "japan-util" "\
Convert Japanese `katakana' chars in the region to `hiragana' chars.

arguments: (FROM TO)
" t nil)

(autoload 'japanese-hankaku-region "japan-util" "\
Convert Japanese `zenkaku' chars in the region to `hankaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument ASCII-ONLY non-nil means to convert only to ASCII char.

arguments: (FROM TO &optional ASCII-ONLY)
" t nil)

(autoload 'japanese-zenkaku-region "japan-util" "\
Convert hankaku' chars in the region to Japanese `zenkaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument KATAKANA-ONLY non-nil means to convert only KATAKANA char.

arguments: (FROM TO &optional KATAKANA-ONLY)
" t nil)

(autoload 'read-hiragana-string "japan-util" "\
Read a Hiragana string from the minibuffer, prompting with string PROMPT.
If non-nil, second arg INITIAL-INPUT is a string to insert before reading.

arguments: (PROMPT &optional INITIAL-INPUT)
" nil nil)

;;;***

;;;### (autoloads (setup-korean-environment-internal) "korea-util" "mule/korea-util.el")

(defvar default-korean-keyboard (if (find ?3 (getenv "HANGUL_KEYBOARD_TYPE")) "3" "") "\
*The kind of Korean keyboard for Korean input method.
\"\" for 2, \"3\" for 3.")

(autoload 'setup-korean-environment-internal "korea-util" "\


arguments: ()
" nil nil)

;;;***

;;;### (autoloads (lao-compose-region lao-composition-function lao-transcribe-roman-to-lao-string lao-transcribe-single-roman-syllable-to-lao lao-compose-string) "lao-util" "mule/lao-util.el")

(autoload 'lao-compose-string "lao-util" "\


arguments: (STR)
" nil nil)

(autoload 'lao-transcribe-single-roman-syllable-to-lao "lao-util" "\
Transcribe a Romanized Lao syllable in the region FROM and TO to Lao string.
Only the first syllable is transcribed.
The value has the form: (START END LAO-STRING), where
START and END are the beginning and end positions of the Roman Lao syllable,
LAO-STRING is the Lao character transcription of it.

Optional 3rd arg STR, if non-nil, is a string to search for Roman Lao
syllable.  In that case, FROM and TO are indexes to STR.

arguments: (FROM TO &optional STR)
" nil nil)

(autoload 'lao-transcribe-roman-to-lao-string "lao-util" "\
Transcribe Romanized Lao string STR to Lao character string.

arguments: (STR)
" nil nil)

(autoload 'lao-composition-function "lao-util" "\
Compose Lao text in the region FROM and TO.
The text matches the regular expression PATTERN.
Optional 4th argument STRING, if non-nil, is a string containing text
to compose.

The return value is number of composed characters.

arguments: (FROM TO PATTERN &optional STRING)
" nil nil)

(autoload 'lao-compose-region "lao-util" "\


arguments: (FROM TO)
" t nil)

;;;***

;;;### (autoloads (thai-composition-function thai-post-read-conversion thai-compose-buffer thai-compose-string thai-compose-region) "thai-util" "mule/thai-util.el")

(autoload 'thai-compose-region "thai-util" "\
Compose Thai characters in the region.
When called from a program, expects two arguments,
positions (integers or markers) specifying the region.

arguments: (BEG END)
" t nil)

(autoload 'thai-compose-string "thai-util" "\
Compose Thai characters in STRING and return the resulting string.

arguments: (STRING)
" nil nil)

(autoload 'thai-compose-buffer "thai-util" "\
Compose Thai characters in the current buffer.

arguments: ()
" t nil)

(autoload 'thai-post-read-conversion "thai-util" "\


arguments: (LEN)
" nil nil)

(autoload 'thai-composition-function "thai-util" "\
Compose Thai text in the region FROM and TO.
The text matches the regular expression PATTERN.
Optional 4th argument STRING, if non-nil, is a string containing text
to compose.

The return value is number of composed characters.

arguments: (FROM TO PATTERN &optional STRING)
" nil nil)

;;;***

;;;### (autoloads (tibetan-pre-write-conversion tibetan-post-read-conversion tibetan-compose-buffer tibetan-decompose-buffer tibetan-composition-function tibetan-decompose-string tibetan-decompose-region tibetan-compose-region tibetan-compose-string tibetan-transcription-to-tibetan tibetan-tibetan-to-transcription tibetan-char-p) "tibet-util" "mule/tibet-util.el")

(autoload 'tibetan-char-p "tibet-util" "\
Check if char CH is Tibetan character.
Returns non-nil if CH is Tibetan. Otherwise, returns nil.

arguments: (CH)
" nil nil)

(autoload 'tibetan-tibetan-to-transcription "tibet-util" "\
Transcribe Tibetan string STR and return the corresponding Roman string.

arguments: (STR)
" nil nil)

(autoload 'tibetan-transcription-to-tibetan "tibet-util" "\
Convert Tibetan Roman string STR to Tibetan character string.
The returned string has no composition information.

arguments: (STR)
" nil nil)

(autoload 'tibetan-compose-string "tibet-util" "\
Compose Tibetan string STR.

arguments: (STR)
" nil nil)

(autoload 'tibetan-compose-region "tibet-util" "\
Compose Tibetan text the region BEG and END.

arguments: (BEG END)
" t nil)

(autoload 'tibetan-decompose-region "tibet-util" "\
Decompose Tibetan text in the region FROM and TO.
This is different from decompose-region because precomposed Tibetan characters
are decomposed into normal Tiebtan character sequences.

arguments: (FROM TO)
" t nil)

(autoload 'tibetan-decompose-string "tibet-util" "\
Decompose Tibetan string STR.
This is different from decompose-string because precomposed Tibetan characters
are decomposed into normal Tiebtan character sequences.

arguments: (STR)
" nil nil)

(autoload 'tibetan-composition-function "tibet-util" "\


arguments: (FROM TO PATTERN &optional STRING)
" nil nil)

(autoload 'tibetan-decompose-buffer "tibet-util" "\
Decomposes Tibetan characters in the buffer into their components.
See also the documentation of the function `tibetan-decompose-region'.

arguments: ()
" t nil)

(autoload 'tibetan-compose-buffer "tibet-util" "\
Composes Tibetan character components in the buffer.
See also docstring of the function tibetan-compose-region.

arguments: ()
" t nil)

(autoload 'tibetan-post-read-conversion "tibet-util" "\


arguments: (LEN)
" nil nil)

(autoload 'tibetan-pre-write-conversion "tibet-util" "\


arguments: (FROM TO)
" nil nil)

;;;***

;;;### (autoloads (viqr-pre-write-conversion viqr-post-read-conversion viet-encode-viqr-buffer viet-encode-viqr-region viet-decode-viqr-buffer viet-decode-viqr-region viet-encode-viscii-char) "viet-util" "mule/viet-util.el")

(autoload 'viet-encode-viscii-char "viet-util" "\
Return VISCII character code of CHAR if appropriate.

arguments: (CHAR)
" nil nil)

(autoload 'viet-decode-viqr-region "viet-util" "\
Convert `VIQR' mnemonics of the current region to Vietnamese characters.
When called from a program, expects two arguments,
positions (integers or markers) specifying the stretch of the region.

arguments: (FROM TO)
" t nil)

(autoload 'viet-decode-viqr-buffer "viet-util" "\
Convert `VIQR' mnemonics of the current buffer to Vietnamese characters.

arguments: ()
" t nil)

(autoload 'viet-encode-viqr-region "viet-util" "\
Convert Vietnamese characters of the current region to `VIQR' mnemonics.
When called from a program, expects two arguments,
positions (integers or markers) specifying the stretch of the region.

arguments: (FROM TO)
" t nil)

(autoload 'viet-encode-viqr-buffer "viet-util" "\
Convert Vietnamese characters of the current buffer to `VIQR' mnemonics.

arguments: ()
" t nil)

(autoload 'viqr-post-read-conversion "viet-util" "\


arguments: (LEN)
" nil nil)

(autoload 'viqr-pre-write-conversion "viet-util" "\


arguments: (FROM TO)
" nil nil)

;;;***

(provide 'mule-autoloads)
