# $Id: iqibb.tcl 1038 2007-03-10 14:09:40Z sergei $
#
# IQ-based In-Band Bytestreams (XEP is to be submitted) transport for SI
#

###############################################################################

namespace eval iqibb {}

set ::NS(iqibb) http://jabber.org/protocol/iqibb

###############################################################################

proc iqibb::connect {stream chunk_size command} {
    upvar #0 $stream state

    set_status [::msgcat::mc "Opening IQ-IBB connection"]

    jlib::send_iq set \
	[jlib::wrapper:createtag open \
	     -vars [list xmlns $::NS(iqibb) \
			 sid $state(id) \
			 block-size $chunk_size]] \
	-to $state(jid) \
	-connection $state(connid) \
	-command [list [namespace current]::recv_connect_response \
		      $stream $command]
}

proc iqibb::recv_connect_response {stream command res child} {
    upvar #0 $stream state

    if {$res != "OK"} {
	uplevel #0 $command [list [list 0 [error_to_string $child]]]
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set state(seq) 0
    uplevel #0 $command 1
}

###############################################################################

package require base64

proc iqibb::send_data {stream data command} {
    upvar #0 $stream state

    jlib::send_iq set \
	[jlib::wrapper:createtag data \
	     -vars [list xmlns $::NS(iqibb) \
			 sid $state(id) \
			 seq $state(seq)] \
	     -chdata [base64::encode $data]] \
	-to $state(jid) \
	-command [list [namespace current]::send_data_ack $stream $command] \
	-connection $state(connid)

    set state(seq) [expr {($state(seq) + 1) % 65536}]
}

proc iqibb::send_data_ack {stream command res child} {
    if {$res != "OK"} {
	uplevel #0 $command [list [list 0 [error_to_string $child]]]
    } else {
	uplevel #0 $command 1
    }
}

###############################################################################

proc iqibb::close {stream} {
    upvar #0 $stream state

    jlib::send_iq set \
	[jlib::wrapper:createtag close \
	     -vars [list xmlns $::NS(iqibb) \
			 sid $state(id)]] \
	-to $state(jid) \
	-connection $state(connid)
}

###############################################################################

proc iqibb::iq_set_handler {connid from lang child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set id [jlib::wrapper:getattr $vars sid]
    if {[catch {si::in $connid $from $id} stream]} {
	return [list error modify bad-request \
		     -text [::trans::trans $lang \
					   "Stream ID has not been negotiated"]]
    }
    upvar #0 $stream state

    switch -- $tag {
	open {
	    set state(block-size) [jlib::wrapper:getattr $vars block-size]
	    set state(seq) 0
	}
	close {
	    si::closed $stream
	}
	data {
	    set seq [jlib::wrapper:getattr $vars seq]
	    if {$seq != $state(seq)} {
		si::closed $stream
		return [list error modify bad-request \
			     -text [::trans::trans $lang \
					"Unexpected packet sequence number"]]
	    } else {
		set state(seq) [expr {($state(seq) + 1) % 65536}]
	    }
	    set data $chdata

	    if {[catch {set decoded [base64::decode $data]}]} {
		debugmsg si "IQIBB: WRONG DATA"
		si::closed $stream
		return [list error modify bad-request \
			     -text [::trans::trans $lang \
					"Cannot decode recieved data"]]
	    } else {
		debugmsg si "IQIBB: RECV DATA [list $data]"
		if {![si::recv_data $stream $decoded]} {
		    si::closed $stream
		    return [list error cancel not-allowed \
				 -text [::trans::trans $lang \
					    "File transfer is aborted"]]
		}
	    }
	}
    }

    return [list result ""]
}

iq::register_handler set "" $::NS(iqibb) \
		     [namespace current]::iqibb::iq_set_handler

###############################################################################

si::register_transport $::NS(iqibb) $::NS(iqibb) 70 \
		       [namespace current]::iqibb::connect \
		       [namespace current]::iqibb::send_data \
		       [namespace current]::iqibb::close

###############################################################################

