/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private static final int propertyChangeSupportSerializedDataVersion = 2;
    private Hashtable children;
    private final Object source;
    private transient Vector listeners;

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.addPropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(l);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.removePropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else if (this.listeners != null) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList list2 = new ArrayList();
        if (this.listeners != null) {
            list2.addAll(this.listeners);
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = (Map.Entry)iter.next();
                String name = (String)e.getKey();
                Vector v = ((PropertyChangeSupport)e.getValue()).listeners;
                int j = v.size();
                while (--j >= 0) {
                    list2.add(new PropertyChangeListenerProxy(name, (PropertyChangeListener)v.get(j)));
                }
            }
        }
        return (PropertyChangeListener[])list2.toArray(new PropertyChangeListener[list2.size()]);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        while (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : !propertyName.equals(p.propertyName)) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
        }
        PropertyChangeSupport s = null;
        if (this.children == null) {
            this.children = new Hashtable();
        } else {
            s = (PropertyChangeSupport)this.children.get(propertyName);
        }
        if (s == null) {
            s = new PropertyChangeSupport(this.source);
            s.listeners = new Vector();
            this.children.put(propertyName, s);
        }
        s.listeners.add(l);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.children == null) {
            return;
        }
        s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : propertyName.equals(p.propertyName) == false) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
lbl10:
            // 2 sources

            ** while (l instanceof PropertyChangeListenerProxy)
        }
lbl11:
        // 1 sources

        s.listeners.remove(l);
        if (s.listeners.isEmpty()) {
            this.children.remove(propertyName);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.children == null) {
            return new PropertyChangeListener[0];
        }
        PropertyChangeSupport s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s == null) {
            return new PropertyChangeListener[0];
        }
        return (PropertyChangeListener[])s.listeners.toArray(new PropertyChangeListener[s.listeners.size()]);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
    }

    public void firePropertyChange(String propertyName, int oldVal, int newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, new Integer(oldVal), new Integer(newVal)));
        }
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        PropertyChangeSupport s;
        Hashtable h;
        if (event.oldValue != null && event.oldValue.equals(event.newValue)) {
            return;
        }
        Vector v = this.listeners;
        if (v != null) {
            int i = v.size();
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
        if ((h = this.children) != null && event.propertyName != null && (s = (PropertyChangeSupport)h.get(event.propertyName)) != null) {
            v = s.listeners;
            int n = 0;
            if (v != null) {
                n = v.size();
            }
            int i = n;
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        boolean bl = false;
        if (this.listeners != null || this.children != null && this.children.get(propertyName) != null) {
            bl = true;
        }
        return bl;
    }

    private final synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.listeners != null) {
            int i = this.listeners.size();
            while (--i >= 0) {
                if (!(this.listeners.get(i) instanceof Serializable)) continue;
                s.writeObject(this.listeners.get(i));
            }
        }
        s.writeObject(null);
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        PropertyChangeListener l = (PropertyChangeListener)s.readObject();
        while (l != null) {
            this.addPropertyChangeListener(l);
            l = (PropertyChangeListener)s.readObject();
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = (Map.Entry)iter.next();
                String name = (String)e.getKey();
                PropertyChangeSupport pcs = (PropertyChangeSupport)e.getValue();
                if (pcs.listeners == null) {
                    pcs.listeners = new Vector();
                }
                if (pcs.children != null) {
                    pcs.listeners.addAll(Arrays.asList(pcs.getPropertyChangeListeners(name)));
                }
                if (pcs.listeners.size() == 0) {
                    iter.remove();
                    continue;
                }
                pcs.children = null;
            }
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }

    public PropertyChangeSupport(Object source) {
        this.source = source;
        if (source == null) {
            throw new NullPointerException();
        }
    }
}

