/*****
 NAME
	pallocators.h - protocol definition for Object class group
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PALLOCATOR_H_INCLUDED)
#define	PALLOCATOR_H_INCLUDED

#include <coconut/pobject.h>

@protocol PAllocatorFactory 
 + (void *) allocate: (size_t) size ;
 + (void *) reallocate: (void *) ptr size:(size_t) size ;
   /* if you pass the null pointer as "p", the memory spaces sized "size"
      which contains unknown data are returned */
 + (void *) duplicate: (const void *) p size: (size_t) size ;
 + free: (void *) p ;
@end

@protocol PAllocator <PObject>
  - (void *) allocate: (size_t) reqsize ;
  - (void *) reallocate: (void *) src size: (size_t) size ;
  - free: (void *) src ;

  - (id <PAllocator>) duplicate ;
@end

@protocol PObstack <PAllocator>
  - grow: (void *) src size: (size_t) size ;
  - growChar: (utf8_char) c ;
  - growPtr: (const void *) p ;
  - growInt: (int) i ;

  - (void *) finish ;
  - rewind: (const void *) ptr ;
  - clear ;
@end

#endif	/* !defined(PALLOCATOR_H_INCLUDED) */

