/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpPacket;
import gnu.classpath.jdwp.transport.TransportException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class JdwpConnection
extends Thread {
    private static final byte[] _HANDSHAKE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private ITransport _transport;
    private ArrayList _commandQueue;
    private boolean _shutdown;
    private DataInputStream _inStream;
    private DataOutputStream _outStream;
    private ByteArrayOutputStream _bytes;
    private DataOutputStream _doStream;

    public void initialize() throws TransportException {
        this._transport.initialize();
        try {
            this._inStream = new DataInputStream(this._transport.getInputStream());
            this._outStream = new DataOutputStream(this._transport.getOutputStream());
            this._doHandshake();
        }
        catch (IOException ioe) {
            throw new TransportException(ioe);
        }
    }

    private final void _doHandshake() throws IOException {
        byte[] hshake = new byte[_HANDSHAKE.length];
        this._inStream.readFully(hshake, 0, _HANDSHAKE.length);
        if (Arrays.equals(hshake, _HANDSHAKE)) {
            this._outStream.write(_HANDSHAKE, 0, _HANDSHAKE.length);
            return;
        }
        throw new IOException("invalid JDWP handshake (\"" + hshake + "\")");
    }

    public void run() {
        while (!this._shutdown) {
            try {
                this._readOnePacket();
            }
            catch (IOException ioe) {
                Jdwp.getDefault().shutdown();
            }
            catch (Throwable t) {
                System.out.println("JdwpConnection.run: caught an exception: " + t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _readOnePacket() throws IOException {
        byte[] data = null;
        int length = this._inStream.readInt();
        if (length < 11) {
            throw new IOException("JDWP packet length < 11 (" + length + ')');
        }
        data = new byte[length];
        data[0] = (byte)(length >>> 24);
        data[1] = (byte)(length >>> 16);
        data[2] = (byte)(length >>> 8);
        data[3] = (byte)length;
        this._inStream.readFully(data, 4, length - 4);
        JdwpPacket packet = JdwpPacket.fromBytes(data);
        if (packet == null) return;
        ArrayList arrayList = this._commandQueue;
        synchronized (arrayList) {
            this._commandQueue.add(packet);
            this._commandQueue.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdwpPacket getPacket() {
        ArrayList arrayList = this._commandQueue;
        synchronized (arrayList) {
            while (this._commandQueue.isEmpty()) {
                try {
                    this._commandQueue.wait();
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            return (JdwpPacket)this._commandQueue.remove(0);
        }
    }

    public void sendPacket(JdwpPacket pkt) throws IOException {
        pkt.write(this._outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendEvent(EventRequest request, Event event) throws IOException {
        JdwpPacket pkt;
        ByteArrayOutputStream byteArrayOutputStream = this._bytes;
        synchronized (byteArrayOutputStream) {
            this._bytes.reset();
            pkt = event.toPacket(this._doStream, request);
            pkt.setData(this._bytes.toByteArray());
        }
        this.sendPacket(pkt);
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._transport.shutdown();
            this._shutdown = true;
            this.interrupt();
        }
    }

    public JdwpConnection(ThreadGroup group, ITransport transport) {
        super(group, "JDWP connection thread");
        this._transport = transport;
        this._commandQueue = new ArrayList();
        this._shutdown = false;
        this._bytes = new ByteArrayOutputStream();
        this._doStream = new DataOutputStream(this._bytes);
    }
}

