/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ReferenceTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeSignature(bb, os);
                    break;
                }
                case 2: {
                    this.executeClassLoader(bb, os);
                    break;
                }
                case 3: {
                    this.executeModifiers(bb, os);
                    break;
                }
                case 4: {
                    this.executeFields(bb, os);
                    break;
                }
                case 5: {
                    this.executeMethods(bb, os);
                    break;
                }
                case 6: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 7: {
                    this.executeSourceFile(bb, os);
                    break;
                }
                case 8: {
                    this.executeNestedTypes(bb, os);
                    break;
                }
                case 9: {
                    this.executeStatus(bb, os);
                    break;
                }
                case 10: {
                    this.executeInterfaces(bb, os);
                    break;
                }
                case 11: {
                    this.executeClassObject(bb, os);
                    break;
                }
                case 12: {
                    this.executeSourceDebugExtension(bb, os);
                    break;
                }
                case 13: {
                    this.executeSignatureWithGeneric(bb, os);
                    break;
                }
                case 14: {
                    this.executeFieldWithGeneric(bb, os);
                    break;
                }
                case 15: {
                    this.executeMethodsWithGeneric(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ReferenceType Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeSignature(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        String sig = Signature.computeClassSignature(refId.getType());
        JdwpString.writeString(os, sig);
    }

    private final void executeClassLoader(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ClassLoader loader = clazz.getClassLoader();
        ObjectId oid = this.idMan.getObjectId(loader);
        oid.write(os);
    }

    private final void executeModifiers(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        os.writeInt(clazz.getModifiers());
    }

    private final void executeFields(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Field[] fields = clazz.getFields();
        os.writeInt(fields.length);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            this.idMan.getObjectId(field).write(os);
            JdwpString.writeString(os, field.getName());
            JdwpString.writeString(os, Signature.computeFieldSignature(field));
            os.writeInt(field.getModifiers());
            ++i;
        }
    }

    private final void executeMethods(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Method[] methods = clazz.getMethods();
        os.writeInt(methods.length);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            this.idMan.getObjectId(method).write(os);
            JdwpString.writeString(os, method.getName());
            JdwpString.writeString(os, Signature.computeMethodSignature(method));
            os.writeInt(method.getModifiers());
            ++i;
        }
    }

    private final void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        int numFields = bb.getInt();
        os.writeInt(numFields);
        int i = 0;
        while (i < numFields) {
            ObjectId fieldId = this.idMan.readObjectId(bb);
            Field field = (Field)fieldId.getObject();
            Class fieldClazz = field.getDeclaringClass();
            if (fieldClazz.isAssignableFrom(clazz)) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    Value.writeTaggedValue(os, value);
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidFieldException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new JdwpInternalErrorException(ex);
                }
            } else {
                throw new InvalidFieldException(fieldId.getId());
            }
            ++i;
        }
    }

    private final void executeSourceFile(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        String sourceFileName = VMVirtualMachine.getSourceFile(clazz);
        JdwpString.writeString(os, sourceFileName);
    }

    private final void executeNestedTypes(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class[] declaredClazzes = clazz.getDeclaredClasses();
        os.writeInt(declaredClazzes.length);
        int i = 0;
        while (i < declaredClazzes.length) {
            Class decClazz = declaredClazzes[i];
            ReferenceTypeId clazzId = this.idMan.getReferenceTypeId(decClazz);
            clazzId.writeTagged(os);
            ++i;
        }
    }

    private final void executeStatus(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        int status = VMVirtualMachine.getClassStatus(clazz);
        os.writeInt(status);
    }

    private final void executeInterfaces(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class[] interfaces = clazz.getInterfaces();
        os.writeInt(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class interfaceClass = interfaces[i];
            ReferenceTypeId intId = this.idMan.getReferenceTypeId(interfaceClass);
            intId.write(os);
            ++i;
        }
    }

    private final void executeClassObject(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId clazzObjectId = this.idMan.getObjectId(clazz);
        clazzObjectId.write(os);
    }

    private final void executeSourceDebugExtension(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeSignatureWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeFieldWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeMethodsWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }
}

