/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.ClasspathTextLayoutPeer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;

public final class TextLayout
implements Cloneable {
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();
    ClasspathTextLayoutPeer peer;

    /*
     * WARNING - void declaration
     */
    protected final Object clone() {
        try {
            void e;
            TextLayout tl = (TextLayout)super.clone();
            tl.peer = (ClasspathTextLayoutPeer)this.peer.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final void draw(Graphics2D g2, float x, float y) {
        this.peer.draw(g2, x, y);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)obj);
    }

    public final boolean equals(TextLayout tl) {
        return this.peer.equals(tl.peer);
    }

    public final float getAdvance() {
        return this.peer.getAdvance();
    }

    public final float getAscent() {
        return this.peer.getAscent();
    }

    public final byte getBaseline() {
        return this.peer.getBaseline();
    }

    public final float[] getBaselineOffsets() {
        return this.peer.getBaselineOffsets();
    }

    public final Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        return this.peer.getBlackBoxBounds(firstEndpoint, secondEndpoint);
    }

    public final Rectangle2D getBounds() {
        return this.peer.getBounds();
    }

    public final float[] getCaretInfo(TextHitInfo hit) {
        return this.getCaretInfo(hit, this.getBounds());
    }

    public final float[] getCaretInfo(TextHitInfo hit, Rectangle2D bounds) {
        return this.peer.getCaretInfo(hit, bounds);
    }

    public final Shape getCaretShape(TextHitInfo hit) {
        return this.getCaretShape(hit, this.getBounds());
    }

    public final Shape getCaretShape(TextHitInfo hit, Rectangle2D bounds) {
        return this.peer.getCaretShape(hit, bounds);
    }

    public final Shape[] getCaretShapes(int offset) {
        return this.getCaretShapes(offset, this.getBounds());
    }

    public final Shape[] getCaretShapes(int offset, Rectangle2D bounds) {
        return this.getCaretShapes(offset, this.getBounds(), DEFAULT_CARET_POLICY);
    }

    public final Shape[] getCaretShapes(int offset, Rectangle2D bounds, CaretPolicy policy) {
        return this.peer.getCaretShapes(offset, bounds, policy);
    }

    public final int getCharacterCount() {
        return this.peer.getCharacterCount();
    }

    public final byte getCharacterLevel(int index) {
        return this.peer.getCharacterLevel(index);
    }

    public final float getDescent() {
        return this.peer.getDescent();
    }

    public final TextLayout getJustifiedLayout(float justificationWidth) {
        return this.peer.getJustifiedLayout(justificationWidth);
    }

    public final float getLeading() {
        return this.peer.getLeading();
    }

    public final Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint) {
        return this.getLogicalHighlightShape(firstEndpoint, secondEndpoint, this.getBounds());
    }

    public final Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        return this.peer.getLogicalHighlightShape(firstEndpoint, secondEndpoint, bounds);
    }

    public final int[] getLogicalRangesForVisualSelection(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        return this.peer.getLogicalRangesForVisualSelection(firstEndpoint, secondEndpoint);
    }

    public final TextHitInfo getNextLeftHit(int offset) {
        return this.getNextLeftHit(offset, DEFAULT_CARET_POLICY);
    }

    public final TextHitInfo getNextLeftHit(int offset, CaretPolicy policy) {
        return this.peer.getNextLeftHit(offset, policy);
    }

    public final TextHitInfo getNextLeftHit(TextHitInfo hit) {
        return this.getNextLeftHit(hit.getCharIndex());
    }

    public final TextHitInfo getNextRightHit(int offset) {
        return this.getNextRightHit(offset, DEFAULT_CARET_POLICY);
    }

    public final TextHitInfo getNextRightHit(int offset, CaretPolicy policy) {
        return this.peer.getNextRightHit(offset, policy);
    }

    public final TextHitInfo getNextRightHit(TextHitInfo hit) {
        return this.getNextRightHit(hit.getCharIndex());
    }

    public final Shape getOutline(AffineTransform tx) {
        return this.peer.getOutline(tx);
    }

    public final float getVisibleAdvance() {
        return this.peer.getVisibleAdvance();
    }

    public final Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        return this.getVisualHighlightShape(firstEndpoint, secondEndpoint, this.getBounds());
    }

    public final Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint, Rectangle2D bounds) {
        return this.peer.getVisualHighlightShape(firstEndpoint, secondEndpoint, bounds);
    }

    public final TextHitInfo getVisualOtherHit(TextHitInfo hit) {
        return this.peer.getVisualOtherHit(hit);
    }

    protected final void handleJustify(float justificationWidth) {
        this.peer.handleJustify(justificationWidth);
    }

    public final int hashCode() {
        return this.peer.hashCode();
    }

    public final TextHitInfo hitTestChar(float x, float y) {
        return this.hitTestChar(x, y, this.getBounds());
    }

    public final TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        return this.peer.hitTestChar(x, y, bounds);
    }

    public final boolean isLeftToRight() {
        return this.peer.isLeftToRight();
    }

    public final boolean isVertical() {
        return this.peer.isVertical();
    }

    public final String toString() {
        return this.peer.toString();
    }

    public TextLayout(AttributedCharacterIterator text, FontRenderContext frc) {
        AttributedString as = new AttributedString(text);
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = tk.getClasspathTextLayoutPeer(as, frc);
    }

    public TextLayout(String string, Font font, FontRenderContext frc) {
        AttributedString as = new AttributedString(string);
        as.addAttribute(TextAttribute.FONT, font);
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = tk.getClasspathTextLayoutPeer(as, frc);
    }

    public TextLayout(String string, Map attributes, FontRenderContext frc) {
        AttributedString as = new AttributedString(string, attributes);
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = tk.getClasspathTextLayoutPeer(as, frc);
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2, TextLayout layout) {
            return layout.peer.getStrongCaret(hit1, hit2);
        }
    }
}

