/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import net.claribole.zvtm.lens.FixedSizeLens;

public class FSWaveLens
extends FixedSizeLens {
    double d = 0.0;
    float N = 5.0f;

    public FSWaveLens() {
        this.MM = 2.0f;
        this.updateMagBufferWorkingDimensions();
    }

    public FSWaveLens(float mm, float n) {
        this.MM = mm;
        this.N = n;
        this.updateMagBufferWorkingDimensions();
    }

    public FSWaveLens(float mm, int outerRadius, int innerRadius, float n) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.N = n;
        this.updateMagBufferWorkingDimensions();
    }

    public FSWaveLens(float mm, int outerRadius, int innerRadius, float n, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.N = n;
        this.updateMagBufferWorkingDimensions();
        this.lx = x;
        this.ly = y;
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setN(float n) {
        this.N = n;
    }

    public float getN() {
        return this.N;
    }

    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = (float)((double)(this.MM - 1.0f) * Math.sin(this.d / (double)this.N - (double)((float)this.LR2 / this.N)) / (this.d / (double)this.N - (double)((float)this.LR2 / this.N)) + 1.0);
            if (g[0] < 1.0f) {
                g[1] = 1.0f;
                g[0] = 1.0f;
            }
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }
}

