/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.Camera;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.claribole.zgrviewer.GraphicsManager;

public class PNGExportWindow {
    private static final String[] units = new String[]{"pixels", "inches", "cm", "mm"};
    private static final int PIXEL = 0;
    private static final int INCH = 1;
    private static final int CM = 2;
    private static final int MM = 3;
    private static final double CM_PER_INCH = 2.54;
    private static final double MM_PER_INCH = 25.4;
    private int last_dpi = 72;
    private int last_width_unit = 0;
    private int last_height_unit = 0;
    private JFrame frame;
    private JPanel content;
    private JPanel options;
    private JPanel fileSelection;
    private JPanel buttons;
    private JButton export;
    private JButton cancel;
    private JButton browse;
    private TitledBorder optionsBorder;
    private JTextField filePath;
    private SpinnerNumberModel width;
    private SpinnerNumberModel height;
    private JComboBox widthUnit;
    private JComboBox heightUnit;
    private SpinnerNumberModel dpiSpinner;
    private FlowLayout layout;
    private double realWidth;
    private double realHeight;
    private static File selectedFile = null;
    boolean stateLock = false;
    private int dpi = this.last_dpi;
    GraphicsManager grMngr;

    public PNGExportWindow(long w, long h, GraphicsManager gm) {
        this.grMngr = gm;
        if (w < 1L || h < 1L) {
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "Can not export visible region of size 0.", "Export to PNG error", 0);
            return;
        }
        this.realWidth = w;
        this.realHeight = h;
        this.frame = new JFrame("PNG Export Options");
        this.frame.setResizable(false);
        this.content = new JPanel(new BorderLayout());
        this.frame.setContentPane(this.content);
        this.fileSelection = new JPanel(new FlowLayout(2));
        this.filePath = new JTextField();
        this.filePath.setColumns(19);
        if (selectedFile != null) {
            this.filePath.setText(selectedFile.getPath());
        }
        this.browse = new JButton("Browse");
        class BrowseActionListener
        implements ActionListener {
            BrowseActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = selectedFile == null ? new JFileChooser() : new JFileChooser(selectedFile.getParentFile());
                fc.setDialogTitle("Export PNG");
                if (fc.showSaveDialog(PNGExportWindow.this.frame) == 0) {
                    selectedFile = fc.getSelectedFile();
                    if (selectedFile != null) {
                        PNGExportWindow.this.filePath.setText(selectedFile.getPath());
                        PNGExportWindow.this.export.setEnabled(true);
                    } else {
                        PNGExportWindow.this.export.setEnabled(false);
                        PNGExportWindow.this.filePath.setText("");
                    }
                }
            }
        }
        this.browse.addActionListener(new BrowseActionListener());
        this.fileSelection.add(new JLabel("File path: ", 4));
        this.fileSelection.add(this.filePath);
        this.fileSelection.add(this.browse);
        this.content.add((Component)this.fileSelection, "North");
        this.options = new JPanel(new GridLayout(3, 3));
        this.optionsBorder = BorderFactory.createTitledBorder("Export options");
        this.options.setBorder(this.optionsBorder);
        class UnitActionListener
        implements ActionListener {
            UnitActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                PNGExportWindow.this.updateTextFields(false);
            }
        }
        UnitActionListener unitListener = new UnitActionListener();
        class TextChangeListener
        implements ChangeListener {
            TextChangeListener() {
            }

            public void stateChanged(ChangeEvent e) {
                PNGExportWindow.this.updateTextFields(true);
            }
        }
        TextChangeListener textListener = new TextChangeListener();
        this.width = new SpinnerNumberModel(this.realWidth, 1.0, Double.MAX_VALUE, 1.0);
        this.width.addChangeListener(textListener);
        this.widthUnit = new JComboBox<String>(units);
        this.widthUnit.addActionListener(unitListener);
        this.options.add(new JLabel("Image width: ", 4));
        this.options.add(new JSpinner(this.width));
        this.options.add(this.widthUnit);
        this.height = new SpinnerNumberModel(this.realHeight, 1.0, Double.MAX_VALUE, 1.0);
        this.height.addChangeListener(textListener);
        this.heightUnit = new JComboBox<String>(units);
        this.heightUnit.addActionListener(unitListener);
        this.options.add(new JLabel("Image height: ", 4));
        this.options.add(new JSpinner(this.height));
        this.options.add(this.heightUnit);
        this.dpiSpinner = new SpinnerNumberModel(this.last_dpi, 72, 9999, 1);
        class DPIChangeListener
        implements ChangeListener {
            DPIChangeListener() {
            }

            public void stateChanged(ChangeEvent e) {
                PNGExportWindow.this.dpi = PNGExportWindow.this.dpiSpinner.getNumber().intValue();
                PNGExportWindow.this.updateTextFields(false);
                PNGExportWindow.this.last_dpi = PNGExportWindow.this.dpi;
            }
        }
        this.dpiSpinner.addChangeListener(new DPIChangeListener());
        this.options.add(new JLabel("Dots per inch: ", 4));
        this.options.add(new JSpinner(this.dpiSpinner));
        this.content.add((Component)this.options, "Center");
        this.buttons = new JPanel(new FlowLayout(2));
        this.export = new JButton("Export");
        class ExportActionListener
        implements ActionListener {
            ExportActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                PNGExportWindow.this.hide();
                PNGExportWindow.this.grMngr.mainView.setStatusBarText("Exporting to PNG " + PNGExportWindow.this.filePath.getText() + " ... (This operation can take some time)");
                PNGExportWindow.this.realWidth = PNGExportWindow.this.unitToPixel(PNGExportWindow.this.realWidth, PNGExportWindow.this.widthUnit.getSelectedIndex());
                PNGExportWindow.this.realHeight = PNGExportWindow.this.unitToPixel(PNGExportWindow.this.realHeight, PNGExportWindow.this.heightUnit.getSelectedIndex());
                Vector<Camera> layers = new Vector<Camera>();
                layers.add(PNGExportWindow.this.grMngr.mainCamera);
                PNGExportWindow.this.grMngr.mainView.rasterize((int)PNGExportWindow.this.realWidth, (int)PNGExportWindow.this.realHeight, PNGExportWindow.this.grMngr.vsm, new File(PNGExportWindow.this.filePath.getText()), layers);
                PNGExportWindow.this.grMngr.mainView.setStatusBarText("Exporting to PNG " + PNGExportWindow.this.filePath.getText() + " ...done");
            }
        }
        this.export.addActionListener(new ExportActionListener());
        this.export.setEnabled(false);
        this.cancel = new JButton("Cancel");
        class CancelActionListener
        implements ActionListener {
            CancelActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                PNGExportWindow.this.hide();
            }
        }
        this.cancel.addActionListener(new CancelActionListener());
        this.buttons.add(this.cancel);
        this.buttons.add(this.export);
        this.content.add((Component)this.buttons, "South");
        this.updateTextFields(false);
        this.frame.getRootPane().setDefaultButton(this.export);
        this.content.setPreferredSize(new Dimension(400, 200));
        this.frame.pack();
        this.frame.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        this.frame.setVisible(true);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    private void updateTextFields(boolean textChange) {
        if (this.stateLock) {
            return;
        }
        this.stateLock = true;
        String text = "";
        if (textChange) {
            this.realWidth = this.width.getNumber().doubleValue();
            this.realHeight = this.height.getNumber().doubleValue();
        }
        double pixels = this.realWidth;
        pixels = this.unitToPixel(this.realWidth, this.last_width_unit);
        pixels = this.pixelToUnit(pixels, this.widthUnit.getSelectedIndex());
        text = this.widthUnit.getSelectedIndex() == 0 ? "" + (int)pixels : "" + pixels;
        if (text.indexOf(".") >= 0) {
            text = text.substring(0, text.indexOf(".") + 2);
        }
        this.width.setValue(new Double(text));
        this.realWidth = pixels;
        pixels = this.realHeight;
        pixels = this.unitToPixel(this.realHeight, this.last_height_unit);
        pixels = this.pixelToUnit(pixels, this.heightUnit.getSelectedIndex());
        text = this.heightUnit.getSelectedIndex() == 0 ? "" + (int)pixels : "" + pixels;
        if (text.indexOf(".") >= 0) {
            text = text.substring(0, text.indexOf(".") + 2);
        }
        this.height.setValue(new Double(text));
        this.realHeight = pixels;
        this.last_width_unit = this.widthUnit.getSelectedIndex();
        this.last_height_unit = this.heightUnit.getSelectedIndex();
        this.stateLock = false;
    }

    private double unitToPixel(double number, int unit) {
        switch (unit) {
            case 1: {
                number *= (double)this.last_dpi;
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                number = number / 2.54 * (double)this.last_dpi;
                break;
            }
            case 3: {
                number = number / 25.4 * (double)this.last_dpi;
            }
        }
        return number;
    }

    private double pixelToUnit(double pixels, int unit) {
        switch (unit) {
            case 1: {
                pixels /= (double)this.last_dpi;
                break;
            }
            case 0: {
                pixels = pixels * (double)this.dpi / (double)this.last_dpi;
                break;
            }
            case 2: {
                pixels = pixels / (double)this.last_dpi * 2.54;
                break;
            }
            case 3: {
                pixels = pixels / (double)this.last_dpi * 25.4;
            }
        }
        return pixels;
    }
}

