/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.client.util.IOptionPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dbdiff.prefs.DBDiffPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbdiff.prefs.IPluginPreferencesManager;

public class DBDiffPreferencesPanel
extends JPanel
implements IOptionPanel {
    private static final long serialVersionUID = 1L;
    DBDiffPreferenceBean _prefs = null;
    IPluginPreferencesManager pluginPreferencesManager = null;
    JRadioButton tabularPresentationRadioButton = null;
    JRadioButton sideBySidePresentationRadioButton = null;
    JRadioButton internalDiffWindowRadioButton = null;
    JRadioButton externalDiffToolRadionButton = null;
    JLabel externalDiffToolCommandLabel = null;
    JTextField externalDiffToolCommandTextField = null;
    JCheckBox sortColumnsCheckBox = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBDiffPreferencesPanel.class);

    public DBDiffPreferencesPanel(IPluginPreferencesManager pluginPreferencesManager) {
        this.pluginPreferencesManager = pluginPreferencesManager;
        this._prefs = (DBDiffPreferenceBean)pluginPreferencesManager.getPreferences();
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.4;
        this.add((Component)this.createTopPanel(), c);
    }

    private JPanel createTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String tranferOptionsBorderLabel = s_stringMgr.getString("DBDiffPreferencesPanel.presentationOptionsBorderLabel");
        result.setBorder(this.getTitledBorder(tranferOptionsBorderLabel));
        String cbLabel = s_stringMgr.getString("DBDiffPreferencesPanel.tabularPresentationRadioButtonLabel");
        this.tabularPresentationRadioButton = new JRadioButton(cbLabel);
        this.addSideBySidePresentationRadionButton(result, 0, 0);
        ButtonGroup tabularsidebyside = new ButtonGroup();
        tabularsidebyside.add(this.tabularPresentationRadioButton);
        tabularsidebyside.add(this.sideBySidePresentationRadioButton);
        this.addInternalDiffWindowRadionButton(result, 0, 1);
        this.addExternalDiffToolRadioButton(result, 0, 2);
        ButtonGroup internalExternalButtonGroup = new ButtonGroup();
        internalExternalButtonGroup.add(this.internalDiffWindowRadioButton);
        internalExternalButtonGroup.add(this.externalDiffToolRadionButton);
        this.addexternalDiffToolCommandLabel(result, 0, 3);
        this.addExternalDiffToolCommandTextField(result, 1, 3);
        this.addSortColumnsCheckBoxLabel(result, 0, 4);
        this.addTabularPresentationRadioButton(result, 0, 5);
        return result;
    }

    private void addSortColumnsCheckBoxLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        String sortColumnsCheckBoxLabel = s_stringMgr.getString("DBDiffPreferencesPanel.sortColumnsForSideBySideComparisonLabel");
        String sortColumnsCheckBoxToolTip = s_stringMgr.getString("DBDiffPreferencesPanel.sortColumnsForSideBySideComparisonToolTip");
        this.sortColumnsCheckBox = new JCheckBox(sortColumnsCheckBoxLabel);
        this.sortColumnsCheckBox.setToolTipText(sortColumnsCheckBoxToolTip);
        panel.add((Component)this.sortColumnsCheckBox, c);
    }

    private void addTabularPresentationRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.anchor = 17;
        String cbToolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.tabularPresentationRadioButtonToolTipText");
        this.tabularPresentationRadioButton.setToolTipText(cbToolTipText);
        this.tabularPresentationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DBDiffPreferencesPanel.this.tabularPresentationRadioButton) {
                    DBDiffPreferencesPanel.this.internalDiffWindowRadioButton.setEnabled(false);
                    DBDiffPreferencesPanel.this.externalDiffToolRadionButton.setEnabled(false);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandLabel.setEnabled(false);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandTextField.setEnabled(false);
                }
            }
        });
        panel.add((Component)this.tabularPresentationRadioButton, c);
    }

    private void addSideBySidePresentationRadionButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("DBDiffPreferencesPanel.sideBySidePresentationRadionButtonLabel");
        String toolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.sideBySidePresentationRadionButtonToolTip");
        this.sideBySidePresentationRadioButton = new JRadioButton(cbLabelStr);
        this.sideBySidePresentationRadioButton.setToolTipText(toolTipText);
        this.sideBySidePresentationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DBDiffPreferencesPanel.this.sideBySidePresentationRadioButton) {
                    if (!DBDiffPreferencesPanel.this.internalDiffWindowRadioButton.isSelected() && !DBDiffPreferencesPanel.this.externalDiffToolRadionButton.isSelected()) {
                        DBDiffPreferencesPanel.this.internalDiffWindowRadioButton.setSelected(true);
                    }
                    DBDiffPreferencesPanel.this.internalDiffWindowRadioButton.setEnabled(true);
                    DBDiffPreferencesPanel.this.externalDiffToolRadionButton.setEnabled(true);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandLabel.setEnabled(true);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandTextField.setEnabled(true);
                }
            }
        });
        panel.add((Component)this.sideBySidePresentationRadioButton, c);
    }

    private void addExternalDiffToolRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolRadionButtonLabel");
        String toolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolRadionButtonToolTip");
        this.externalDiffToolRadionButton = new JRadioButton(cbLabelStr);
        this.externalDiffToolRadionButton.setToolTipText(toolTipText);
        this.externalDiffToolRadionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DBDiffPreferencesPanel.this.externalDiffToolRadionButton) {
                    DBDiffPreferencesPanel.this.externalDiffToolCommandLabel.setEnabled(true);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandTextField.setEnabled(true);
                }
            }
        });
        panel.add((Component)this.externalDiffToolRadionButton, c);
    }

    private void addInternalDiffWindowRadionButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("DBDiffPreferencesPanel.internalDiffWindowRadionButtonLabel");
        String toolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.internalDiffWindowRadionButtonToolTip");
        this.internalDiffWindowRadioButton = new JRadioButton(cbLabelStr);
        this.internalDiffWindowRadioButton.setToolTipText(toolTipText);
        this.internalDiffWindowRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DBDiffPreferencesPanel.this.internalDiffWindowRadioButton) {
                    DBDiffPreferencesPanel.this.externalDiffToolCommandLabel.setEnabled(false);
                    DBDiffPreferencesPanel.this.externalDiffToolCommandTextField.setEditable(false);
                }
            }
        });
        panel.add((Component)this.internalDiffWindowRadioButton, c);
    }

    private void addexternalDiffToolCommandLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 45, 0, 0);
        String commitLabel = s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandLabel");
        this.externalDiffToolCommandLabel = new JLabel(commitLabel);
        this.externalDiffToolCommandLabel.setHorizontalAlignment(4);
        String commitlabelToolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandToolTip");
        this.externalDiffToolCommandLabel.setToolTipText(commitlabelToolTipText);
        panel.add((Component)this.externalDiffToolCommandLabel, c);
    }

    private void addExternalDiffToolCommandTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.externalDiffToolCommandTextField = new JTextField(10);
        this.externalDiffToolCommandTextField.setHorizontalAlignment(2);
        String commitlabelToolTipText = s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandToolTip");
        this.externalDiffToolCommandTextField.setToolTipText(commitlabelToolTipText);
        panel.add((Component)this.externalDiffToolCommandTextField, c);
    }

    private Border getTitledBorder(String title) {
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new TitledBorder(title));
        return border;
    }

    private void loadData() {
        if (this._prefs.isUseTabularDiffPresenation()) {
            this.tabularPresentationRadioButton.setSelected(true);
        } else {
            this.sideBySidePresentationRadioButton.setSelected(true);
            if (this._prefs.isUseExternalGraphicalDiffTool()) {
                this.externalDiffToolRadionButton.setSelected(true);
                this.externalDiffToolCommandLabel.setEnabled(true);
                this.externalDiffToolCommandTextField.setEnabled(true);
            } else {
                this.internalDiffWindowRadioButton.setSelected(true);
                this.externalDiffToolCommandLabel.setEnabled(false);
                this.externalDiffToolCommandTextField.setEnabled(false);
            }
        }
    }

    private void save() {
        this._prefs.setUseTabularDiffPresenation(this.tabularPresentationRadioButton.isSelected());
        this._prefs.setUseExternalGraphicalDiffTool(this.externalDiffToolRadionButton.isSelected());
        if (this.externalDiffToolRadionButton.isSelected()) {
            this._prefs.setGraphicalToolCommand(this.externalDiffToolCommandTextField.getText());
        }
        this._prefs.setSortColumnsForSideBySideComparison(this.sortColumnsCheckBox.isSelected());
        this.pluginPreferencesManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }

    public String getHint() {
        return s_stringMgr.getString("DBDiffPreferencesPanel.hint");
    }

    public String getTitle() {
        return s_stringMgr.getString("DBDiffPreferencesPanel.title");
    }
}

