/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnShapeHolder;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class DrawnLineHolder
extends DrawnShapeHolder {
    private Rectangle rect;
    private FontMetrics metrics;
    private final Endpoints endpoints;
    private static final Endpoints HORIZ_LINE = new Endpoints(){

        public Rectangle getEndpoints(Rectangle bounds) {
            return new Rectangle(bounds.x, bounds.y, bounds.width, 0);
        }
    };
    private static final Endpoints VERTICAL_LINE = new Endpoints(){

        public Rectangle getEndpoints(Rectangle bounds) {
            return new Rectangle(bounds.x, bounds.y, 0, bounds.height);
        }
    };
    private static final Logger logger = Logger.getLogger(DrawnLineHolder.class.getName());

    public DrawnLineHolder(AbstractDrawnGenerator gen) {
        this(gen, false);
    }

    public DrawnLineHolder(AbstractDrawnGenerator gen, boolean vertical) {
        this(gen, vertical ? VERTICAL_LINE : HORIZ_LINE);
    }

    public DrawnLineHolder(AbstractDrawnGenerator gen, Endpoints endpoints) {
        super(gen);
        this.endpoints = endpoints;
    }

    public DrawnLineHolder(double len, boolean vertical) {
        this(DrawnLineHolder.generatorFor(len), vertical);
    }

    private static AbstractDrawnGenerator generatorFor(double len) {
        Class<? extends AbstractDrawnGenerator> type = AbstractDrawnGenerator.defaultLineType(len);
        return type == DrawnCubicLineGenerator.class ? new DrawnCubicLineGenerator() : new DrawnQuadLineGenerator();
    }

    public void shapeUpToDate(Rectangle cRect, FontMetrics cMetrics) {
        boolean sameMetrics;
        boolean bl = sameMetrics = this.metrics == null == (cMetrics == null) || this.metrics != null && this.metrics.equals(cMetrics);
        if (!sameMetrics || this.rect == null || !this.rect.equals(cRect)) {
            this.rect = (Rectangle)cRect.clone();
            this.metrics = cMetrics;
            Rectangle ends = this.endpoints.getEndpoints(this.rect);
            double x1 = ends.getX();
            double y1 = ends.getY();
            double x2 = x1 + ends.getWidth();
            double y2 = y1 + ends.getHeight();
            if (cMetrics != null) {
                double below = Math.max((double)cMetrics.getDescent() / 10.0, 2.0);
                double yAdj = (double)(cRect.y + cMetrics.getAscent()) + below;
                y1 += yAdj;
                y2 += yAdj;
                x1 -= below;
                x2 += below;
            }
            double xDelta = x2 - x1;
            double yDelta = y2 - y1;
            double len = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
            double angle = Math.atan2(yDelta, xDelta);
            AffineTransform matrix = new AffineTransform();
            matrix.translate(x1, y1);
            matrix.rotate(angle);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "");
                NapkinUtil.printPair(logger, Level.FINE, "1: ", x1, y1);
                NapkinUtil.printPair(logger, Level.FINE, "2: ", x2, y2);
                NapkinUtil.printPair(logger, Level.FINE, "delta = ", xDelta, yDelta);
                logger.log(Level.FINE, "rot = " + angle);
                logger.log(Level.FINE, "angle = " + angle);
                logger.log(Level.FINE, "len = " + len);
            }
            double xScale = len / 100.0;
            matrix.scale(xScale, 1.0);
            this.shape = this.gen.generate(matrix);
        }
    }

    public static interface Endpoints {
        public Rectangle getEndpoints(Rectangle var1);
    }
}

