/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.dnd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jmeld.JMeld;
import org.jmeld.ui.util.ColorUtil;
import org.jmeld.ui.util.Colors;
import org.jmeld.util.StringUtil;

public class DragAndDropPanel
extends JPanel {
    private JComponent leftDragAndDropArea;
    private JComponent rightDragAndDropArea;
    private String leftFileName = "";
    private String rightFileName = "";

    public DragAndDropPanel() {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setLayout(new BoxLayout(this, 0));
        this.leftDragAndDropArea = this.createDragAndDropArea();
        this.rightDragAndDropArea = this.createDragAndDropArea();
        this.add(this.leftDragAndDropArea);
        this.add(Box.createRigidArea(new Dimension(3, 0)));
        this.add(this.rightDragAndDropArea);
        this.addHierarchyListener(this.getHierarchyListener());
        this.addMouseListener(this.getMouseListener());
    }

    private HierarchyListener getHierarchyListener() {
        return new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) != 0L) {
                    JRootPane rootPane = DragAndDropPanel.this.getRootPane();
                    if (rootPane == null) {
                        return;
                    }
                    rootPane.setDropTarget(DragAndDropPanel.this.getDragAndDropTarget());
                }
            }
        };
    }

    private DropTarget getDragAndDropTarget() {
        return new DropTarget(){
            Component orgGlassPane;
            JPanel glassPane;

            public void dragEnter(DropTargetDragEvent dtde) {
                super.dragEnter(dtde);
                if (this.orgGlassPane == null) {
                    this.glassPane = new JPanel(new GridLayout(0, 2, 40, 40));
                    this.glassPane.setBorder(BorderFactory.createEmptyBorder(60, 10, 40, 10));
                    this.glassPane.setOpaque(false);
                    this.glassPane.add(this.createDropPane(DragAndDropPanel.this.leftFileName));
                    this.glassPane.add(this.createDropPane(DragAndDropPanel.this.rightFileName));
                    this.orgGlassPane = DragAndDropPanel.this.getRootPane().getGlassPane();
                    DragAndDropPanel.this.getRootPane().setGlassPane(this.glassPane);
                    this.glassPane.setVisible(true);
                    DragAndDropPanel.this.getRootPane().repaint();
                }
            }

            private JPanel createDropPane(String text) {
                JLabel label = new JLabel(text);
                label.setOpaque(false);
                label.setHorizontalAlignment(2);
                label.setVerticalAlignment(1);
                label.setFont(label.getFont().deriveFont(16.0f));
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)label, "Center");
                p.setBackground(new Color(238, 227, 187, 200));
                p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
                return p;
            }

            public void dragOver(DropTargetDragEvent dtde) {
                super.dragOver(dtde);
            }

            public void dragExit(DropTargetEvent dte) {
                super.dragExit(dte);
                this.resetGlassPane();
            }

            private void resetGlassPane() {
                if (this.orgGlassPane != null) {
                    DragAndDropPanel.this.getRootPane().setGlassPane(this.orgGlassPane);
                    this.orgGlassPane.setVisible(false);
                    this.orgGlassPane = null;
                }
            }

            public void drop(DropTargetDropEvent dtde) {
                boolean left;
                Rectangle b = DragAndDropPanel.this.getRootPane().getBounds();
                Point p = dtde.getLocation();
                String fileName = this.getFileName(dtde);
                if (StringUtil.isEmpty(fileName)) {
                    return;
                }
                boolean bl = left = p.x < (b.width - b.x) / 2;
                if (left) {
                    DragAndDropPanel.this.leftDragAndDropArea.setBackground(Colors.DND_SELECTED_NEW);
                    DragAndDropPanel.this.leftFileName = fileName;
                } else {
                    DragAndDropPanel.this.rightDragAndDropArea.setBackground(Colors.DND_SELECTED_NEW);
                    DragAndDropPanel.this.rightFileName = fileName;
                }
                this.resetGlassPane();
            }

            private String getFileName(DropTargetDropEvent dtde) {
                Transferable t = dtde.getTransferable();
                DataFlavor[] dataFlavors = t.getTransferDataFlavors();
                if (dataFlavors == null) {
                    return null;
                }
                dtde.acceptDrop(dtde.getSourceActions());
                try {
                    for (DataFlavor dataFlavor : dataFlavors) {
                        String fileName;
                        Object data = t.getTransferData(dataFlavor);
                        if (data.getClass() != String.class || !(fileName = (String)data).startsWith("file:")) continue;
                        return fileName;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
    }

    private JComponent createDragAndDropArea() {
        JPanel p = new JPanel();
        p.setOpaque(true);
        p.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        p.setBackground(ColorUtil.brighter(Color.LIGHT_GRAY));
        p.setPreferredSize(new Dimension(20, 0));
        return p;
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                if (StringUtil.isEmpty(DragAndDropPanel.this.leftFileName) || StringUtil.isEmpty(DragAndDropPanel.this.rightFileName)) {
                    return;
                }
                if (DragAndDropPanel.this.leftFileName.equals(DragAndDropPanel.this.rightFileName)) {
                    return;
                }
                DragAndDropPanel.this.leftDragAndDropArea.setBackground(Colors.DND_SELECTED_USED);
                DragAndDropPanel.this.rightDragAndDropArea.setBackground(Colors.DND_SELECTED_USED);
                try {
                    JMeld.getJMeldPanel().openComparison(new File(new URL(DragAndDropPanel.this.leftFileName).toURI()).getAbsolutePath(), new File(new URL(DragAndDropPanel.this.rightFileName).toURI()).getAbsolutePath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
    }
}

