/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OkClosePanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OkClosePanel.class);
    private boolean _executingMode;
    private EventListenerList _listenerList = new EventListenerList();
    private JButton _okBtn;
    private JButton _closeBtn = new JButton(s_stringMgr.getString("OkClosePanel.close"));

    public OkClosePanel() {
        this.createGUI(s_stringMgr.getString("OkClosePanel.ok"));
    }

    public OkClosePanel(String okButtonText) {
        this.createGUI(okButtonText != null ? okButtonText : s_stringMgr.getString("OkClosePanel.ok"));
    }

    public void setExecuting(boolean executingMode) {
        if (executingMode != this._executingMode) {
            this._executingMode = executingMode;
            this._okBtn.setEnabled(!executingMode);
            this._closeBtn.setText(executingMode ? s_stringMgr.getString("OkClosePanel.cancel") : s_stringMgr.getString("OkClosePanel.close"));
            if (!executingMode) {
                this._closeBtn.setEnabled(true);
            }
        }
    }

    public void enableCloseButton(boolean enable) {
        this._closeBtn.setEnabled(enable);
    }

    public synchronized void addListener(IOkClosePanelListener lis) {
        this._listenerList.add(IOkClosePanelListener.class, lis);
    }

    public synchronized void makeOKButtonDefault() throws IllegalStateException {
        JRootPane root = this.getRootPane();
        if (root == null) {
            throw new IllegalStateException("Null RootPane so cannot set default button");
        }
    }

    public JButton getCloseButton() {
        return this._closeBtn;
    }

    public JButton getOKButton() {
        return this._okBtn;
    }

    private void fireButtonPressed(JButton btn) {
        Object[] listeners = this._listenerList.getListenerList();
        OkClosePanelEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IOkClosePanelListener.class) continue;
            if (evt == null) {
                evt = new OkClosePanelEvent(this);
            }
            IOkClosePanelListener lis = (IOkClosePanelListener)listeners[i + 1];
            if (btn == this._okBtn) {
                lis.okPressed(evt);
                continue;
            }
            if (this._executingMode) {
                lis.cancelPressed(evt);
                continue;
            }
            lis.closePressed(evt);
        }
    }

    private void createGUI(String okButtonText) {
        this._okBtn = new JButton(okButtonText);
        JPanel pnl = ButtonBarFactory.buildOKCancelBar((JButton)this._okBtn, (JButton)this._closeBtn);
        this.add(pnl);
        this._okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkClosePanel.this.fireButtonPressed(OkClosePanel.this._okBtn);
            }
        });
        this._closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkClosePanel.this.fireButtonPressed(OkClosePanel.this._closeBtn);
            }
        });
    }
}

