/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StreamSerializer {
    static final int SPACE = 32;
    static final int BANG = 33;
    static final int APOS = 39;
    static final int SLASH = 47;
    static final int BRA = 60;
    static final int KET = 62;
    static final int EQ = 61;
    static final Map HTML_BOOLEAN_ATTRIBUTES = new HashMap();
    protected final String encoding;
    final Charset charset;
    final CharsetEncoder encoder;
    final int mode;
    final Map namespaces;
    protected String eol;
    Collection cdataSectionElements;
    protected boolean discardDefaultContent;
    protected boolean xmlDeclaration;

    void setCdataSectionElements(Collection c) {
        this.cdataSectionElements = c;
    }

    public void serialize(Node node2, OutputStream out) throws IOException {
        this.serialize(node2, out, false);
    }

    void serialize(Node node2, OutputStream out, boolean convertToCdata) throws IOException {
        while (node2 != null) {
            Node next = node2.getNextSibling();
            this.doSerialize(node2, out, convertToCdata);
            node2 = next;
        }
    }

    private final void doSerialize(Node node2, OutputStream out, boolean convertToCdata) throws IOException {
        if (out == null) {
            throw new NullPointerException("no output stream");
        }
        String uri = node2.getNamespaceURI();
        boolean defined = false;
        int nt = node2.getNodeType();
        if (convertToCdata && nt == 3) {
            nt = 4;
        }
        switch (nt) {
            case 2: {
                String prefix = node2.getPrefix();
                if ("http://www.w3.org/2000/xmlns/".equals(uri) || "xmlns".equals(prefix) || prefix != null && prefix.startsWith("xmlns:")) {
                    String nsuri = node2.getNodeValue();
                    if (this.isDefined(nsuri)) break;
                    String name = node2.getLocalName();
                    if (name == null) {
                        name = node2.getNodeName();
                    }
                    this.define(nsuri, name);
                } else if (uri != null && !this.isDefined(uri)) {
                    String nsname = (prefix = this.define(uri, prefix)) == null ? "xmlns" : "xmlns:" + prefix;
                    out.write(32);
                    out.write(this.encodeText(nsname));
                    out.write(61);
                    String nsvalue = "'" + this.encode(uri, true, true) + '\'';
                    out.write(nsvalue.getBytes(this.encoding));
                    defined = true;
                }
                out.write(32);
                String a_nodeName = node2.getNodeName();
                out.write(this.encodeText(a_nodeName));
                String a_nodeValue = node2.getNodeValue();
                if (this.mode == 1 && a_nodeName.equals(a_nodeValue) && this.isHTMLBoolean((Attr)node2, a_nodeName)) break;
                out.write(61);
                String value = "'" + this.encode(a_nodeValue, true, true) + '\'';
                out.write(this.encodeText(value));
                break;
            }
            case 1: {
                NamedNodeMap attrs;
                String value = node2.getNodeName();
                out.write(60);
                out.write(this.encodeText(value));
                if (uri != null && !this.isDefined(uri)) {
                    String prefix = this.define(uri, node2.getPrefix());
                    String nsname = prefix == null ? "xmlns" : "xmlns:" + prefix;
                    out.write(32);
                    out.write(this.encodeText(nsname));
                    out.write(61);
                    String nsvalue = "'" + this.encode(uri, true, true) + '\'';
                    out.write(this.encodeText(nsvalue));
                    defined = true;
                }
                if ((attrs = node2.getAttributes()) != null) {
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr attr = (Attr)attrs.item(i);
                        if (!this.discardDefaultContent || attr.getSpecified()) {
                            this.serialize(attr, out, false);
                        }
                        ++i;
                    }
                }
                convertToCdata = this.cdataSectionElements.contains(value);
                Node children = node2.getFirstChild();
                if (children == null) {
                    out.write(47);
                    out.write(62);
                    break;
                }
                out.write(62);
                this.serialize(children, out, convertToCdata);
                out.write(60);
                out.write(47);
                out.write(this.encodeText(value));
                out.write(62);
                break;
            }
            case 3: {
                String value = node2.getNodeValue();
                if (!"yes".equals(node2.getUserData("disable-output-escaping"))) {
                    value = this.encode(value, false, false);
                }
                out.write(this.encodeText(value));
                break;
            }
            case 4: {
                String value = "<![CDATA[" + node2.getNodeValue() + "]]>";
                out.write(this.encodeText(value));
                break;
            }
            case 8: {
                String value = "<!--" + node2.getNodeValue() + "-->";
                out.write(this.encodeText(value));
                Node cp = node2.getParentNode();
                if (cp == null || cp.getNodeType() != 9) break;
                out.write(this.encodeText(this.eol));
                break;
            }
            case 9: 
            case 11: {
                if (this.mode == 0) {
                    if ("UTF-16".equalsIgnoreCase(this.encoding)) {
                        out.write(254);
                        out.write(255);
                    }
                    if (!"yes".equals(node2.getUserData("omit-xml-declaration")) && this.xmlDeclaration) {
                        String version;
                        Document doc = node2 instanceof Document ? (Document)node2 : null;
                        String string = version = doc != null ? doc.getXmlVersion() : null;
                        if (version == null) {
                            version = (String)node2.getUserData("version");
                        }
                        if (version == null) {
                            version = "1.0";
                        }
                        out.write(60);
                        out.write(63);
                        out.write("xml version='".getBytes("US-ASCII"));
                        out.write(version.getBytes("US-ASCII"));
                        out.write(39);
                        if (!"UTF-8".equalsIgnoreCase(this.encoding)) {
                            out.write(" encoding='".getBytes("US-ASCII"));
                            out.write(this.encoding.getBytes("US-ASCII"));
                            out.write(39);
                        }
                        if (doc != null && doc.getXmlStandalone() || "yes".equals(node2.getUserData("standalone"))) {
                            out.write(" standalone='yes'".getBytes("US-ASCII"));
                        }
                        out.write(63);
                        out.write(62);
                        out.write(this.encodeText(this.eol));
                    }
                } else if (this.mode == 1) {
                    String mediaType = (String)node2.getUserData("media-type");
                    if (mediaType == null) {
                        mediaType = "text/html";
                    }
                    String contentType = mediaType + "; charset=" + (this.encoding.indexOf(32) != -1 ? "\"" + this.encoding + '\"' : this.encoding);
                    Document doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                    Node html = null;
                    Node ctx = node2.getFirstChild();
                    while (ctx != null) {
                        if (ctx.getNodeType() == 1) {
                            html = ctx;
                            break;
                        }
                        ctx = ctx.getNextSibling();
                    }
                    if (html == null) {
                        html = doc.createElement("html");
                        node2.appendChild(html);
                    }
                    Node head = null;
                    Node ctx2 = html.getFirstChild();
                    while (ctx2 != null) {
                        if (ctx2.getNodeType() == 1) {
                            String name = ctx2.getLocalName();
                            if (name == null) {
                                name = ctx2.getNodeName();
                            }
                            if ("head".equalsIgnoreCase(name)) {
                                head = ctx2;
                                break;
                            }
                        }
                        ctx2 = ctx2.getNextSibling();
                    }
                    if (head == null) {
                        head = doc.createElement("head");
                        Node c1 = null;
                        Node ctx3 = html.getFirstChild();
                        while (ctx3 != null) {
                            if (ctx3.getNodeType() == 1) {
                                c1 = ctx3;
                                break;
                            }
                            ctx3 = ctx3.getNextSibling();
                        }
                        if (c1 != null) {
                            html.insertBefore(head, c1);
                        } else {
                            html.appendChild(head);
                        }
                    }
                    Node meta = null;
                    Node metaContent = null;
                    Node ctx4 = head.getFirstChild();
                    while (ctx4 != null) {
                        if (ctx4.getNodeType() == 1) {
                            String name = ctx4.getLocalName();
                            if (name == null) {
                                name = ctx4.getNodeName();
                            }
                            if ("meta".equalsIgnoreCase(name)) {
                                NamedNodeMap metaAttrs = ctx4.getAttributes();
                                int len = metaAttrs.getLength();
                                String httpEquiv = null;
                                Node content = null;
                                int i = 0;
                                while (i < len) {
                                    Node attr = metaAttrs.item(i);
                                    String attrName = attr.getNodeName();
                                    if ("http-equiv".equalsIgnoreCase(attrName)) {
                                        httpEquiv = attr.getNodeValue();
                                    } else if ("content".equalsIgnoreCase(attrName)) {
                                        content = attr;
                                    }
                                    ++i;
                                }
                                if ("Content-Type".equalsIgnoreCase(httpEquiv)) {
                                    meta = ctx4;
                                    metaContent = content;
                                    break;
                                }
                            }
                        }
                        ctx4 = ctx4.getNextSibling();
                    }
                    if (meta == null) {
                        meta = doc.createElement("meta");
                        Node first = head.getFirstChild();
                        if (first == null) {
                            head.appendChild(meta);
                        } else {
                            head.insertBefore(meta, first);
                        }
                        Attr metaHttpEquiv = doc.createAttribute("http-equiv");
                        meta.getAttributes().setNamedItem(metaHttpEquiv);
                        metaHttpEquiv.setNodeValue("Content-Type");
                    }
                    if (metaContent == null) {
                        metaContent = doc.createAttribute("content");
                        meta.getAttributes().setNamedItem(metaContent);
                    }
                    metaContent.setNodeValue(contentType);
                }
                Node children = node2.getFirstChild();
                if (children == null) break;
                this.serialize(children, out, convertToCdata);
                break;
            }
            case 10: {
                String internalSubset;
                String systemId;
                DocumentType doctype = (DocumentType)node2;
                out.write(60);
                out.write(33);
                out.write(this.encodeText("DOCTYPE "));
                String value = doctype.getNodeName();
                out.write(this.encodeText(value));
                String publicId = doctype.getPublicId();
                if (publicId != null) {
                    out.write(this.encodeText(" PUBLIC "));
                    out.write(39);
                    out.write(this.encodeText(publicId));
                    out.write(39);
                }
                if ((systemId = doctype.getSystemId()) != null) {
                    out.write(this.encodeText(" SYSTEM "));
                    out.write(39);
                    out.write(this.encodeText(systemId));
                    out.write(39);
                }
                if ((internalSubset = doctype.getInternalSubset()) != null) {
                    out.write(this.encodeText(internalSubset));
                }
                out.write(62);
                out.write(this.eol.getBytes(this.encoding));
                break;
            }
            case 5: {
                String value = "&" + node2.getNodeValue() + ';';
                out.write(this.encodeText(value));
                break;
            }
            case 7: {
                String value = "<?" + node2.getNodeName() + ' ' + node2.getNodeValue() + "?>";
                out.write(this.encodeText(value));
                Node pp = node2.getParentNode();
                if (pp == null || pp.getNodeType() != 9) break;
                out.write(this.encodeText(this.eol));
                break;
            }
        }
        if (defined) {
            this.undefine(uri);
        }
    }

    boolean isDefined(String uri) {
        boolean bl = false;
        if ("http://www.w3.org/XML/1998/namespace".equals(uri) || "http://www.w3.org/2000/xmlns/".equals(uri) || this.namespaces.containsKey(uri)) {
            bl = true;
        }
        return bl;
    }

    String define(String uri, String prefix) {
        while (this.namespaces.containsValue(prefix)) {
            prefix = prefix + '_';
        }
        this.namespaces.put(uri, prefix);
        return prefix;
    }

    void undefine(String uri) {
        this.namespaces.remove(uri);
    }

    final byte[] encodeText(String text) throws IOException {
        int len;
        this.encoder.reset();
        if (!this.encoder.canEncode(text)) {
            StringBuffer buf = new StringBuffer();
            len = text.length();
            int i = 0;
            while (i < len) {
                char c = text.charAt(i);
                if (this.encoder.canEncode(c)) {
                    buf.append(c);
                } else {
                    String hex = Integer.toHexString(c);
                    buf.append("&#x");
                    buf.append(hex);
                    buf.append(';');
                }
                ++i;
            }
            text = buf.toString();
        }
        ByteBuffer encoded = this.encoder.encode(CharBuffer.wrap(text));
        len = encoded.limit() - encoded.position();
        if (encoded.hasArray()) {
            byte[] ret = encoded.array();
            if (ret.length > len) {
                byte[] ret2 = new byte[len];
                System.arraycopy(ret, 0, ret2, 0, len);
                ret = ret2;
            }
            return ret;
        }
        encoded.flip();
        byte[] ret = new byte[len];
        encoded.get(ret, 0, len);
        return ret;
    }

    String encode(String text, boolean encodeCtl, boolean inAttr) {
        int len = text.length();
        StringBuffer buf = null;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '<') {
                if (buf == null) {
                    buf = new StringBuffer(text.substring(0, i));
                }
                buf.append("&lt;");
            } else if (c == '>') {
                if (buf == null) {
                    buf = new StringBuffer(text.substring(0, i));
                }
                buf.append("&gt;");
            } else if (c == '&') {
                if (this.mode == 1 && i + 1 < len && text.charAt(i + 1) == '{') {
                    if (buf != null) {
                        buf.append(c);
                    }
                } else {
                    if (buf == null) {
                        buf = new StringBuffer(text.substring(0, i));
                    }
                    buf.append("&amp;");
                }
            } else if (c == '\'' && inAttr) {
                if (buf == null) {
                    buf = new StringBuffer(text.substring(0, i));
                }
                buf.append("&apos;");
            } else if (c == '\"' && inAttr) {
                if (buf == null) {
                    buf = new StringBuffer(text.substring(0, i));
                }
                buf.append("&quot;");
            } else if (encodeCtl) {
                if (c < ' ') {
                    if (buf == null) {
                        buf = new StringBuffer(text.substring(0, i));
                    }
                    buf.append('&');
                    buf.append('#');
                    buf.append((int)c);
                    buf.append(';');
                } else if (buf != null) {
                    buf.append(c);
                }
            } else if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf == null ? text : buf.toString();
    }

    String toString(Node node2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serialize(node2, out);
            return new String(out.toByteArray(), this.encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    boolean isHTMLBoolean(Attr attr, String attrName) {
        attrName = attrName.toLowerCase();
        Element element = attr.getOwnerElement();
        String elementName = element.getLocalName();
        if (elementName == null) {
            elementName = element.getNodeName();
        }
        elementName = elementName.toLowerCase();
        Collection attributes = (Collection)HTML_BOOLEAN_ATTRIBUTES.get(elementName);
        boolean bl = false;
        if (attributes != null && attributes.contains(attrName)) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.cdataSectionElements = Collections.EMPTY_SET;
        this.xmlDeclaration = true;
    }

    public StreamSerializer() {
        this(0, null, null);
    }

    public StreamSerializer(String encoding) {
        this(0, encoding, null);
    }

    public StreamSerializer(int mode, String encoding, String eol) {
        this.this();
        this.mode = mode;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.encoding = encoding.intern();
        this.charset = Charset.forName(this.encoding);
        this.encoder = this.charset.newEncoder();
        this.eol = eol != null ? eol : System.getProperty("line.separator");
        this.namespaces = new HashMap();
    }

    static {
        HashSet set = new HashSet();
        set.add("nohref");
        HTML_BOOLEAN_ATTRIBUTES.put("area", set);
        set = new HashSet();
        set.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("img", set);
        set = new HashSet();
        set.add("declare");
        HTML_BOOLEAN_ATTRIBUTES.put("object", set);
        set = new HashSet();
        set.add("noshade");
        HTML_BOOLEAN_ATTRIBUTES.put("hr", set);
        set = new HashSet();
        set.add("compact");
        HTML_BOOLEAN_ATTRIBUTES.put("dl", set);
        HTML_BOOLEAN_ATTRIBUTES.put("ol", set);
        HTML_BOOLEAN_ATTRIBUTES.put("ul", set);
        HTML_BOOLEAN_ATTRIBUTES.put("dir", set);
        HTML_BOOLEAN_ATTRIBUTES.put("menu", set);
        set = new HashSet();
        set.add("checked");
        set.add("disabled");
        set.add("readonly");
        set.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("input", set);
        set = new HashSet();
        set.add("multiple");
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("select", set);
        set = new HashSet();
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("optgroup", set);
        set = new HashSet();
        set.add("selected");
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("option", set);
        set = new HashSet();
        set.add("disabled");
        set.add("readonly");
        HTML_BOOLEAN_ATTRIBUTES.put("textarea", set);
        set = new HashSet();
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("button", set);
        set = new HashSet();
        set.add("nowrap");
        HTML_BOOLEAN_ATTRIBUTES.put("th", set);
        HTML_BOOLEAN_ATTRIBUTES.put("td", set);
        set = new HashSet();
        set.add("noresize");
        HTML_BOOLEAN_ATTRIBUTES.put("frame", set);
        set = new HashSet();
        set.add("defer");
        HTML_BOOLEAN_ATTRIBUTES.put("script", set);
    }
}

