/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.adapters;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetDependencyManagerAdapter {
    private static final ExtensionPointName<PuppetDependencyManagerAdapter> EP_NAME = ExtensionPointName.create((String)"com.intellij.puppet.dependencyManagerAdapter");

    public abstract boolean isApplicable(@NotNull PuppetEntity var1);

    protected abstract void installDependencies(@NotNull PuppetEntity var1, @NotNull ProgressIndicator var2);

    public final void installDependencies(final @Nullable PuppetEntity puppetEntity) {
        if (puppetEntity == null) {
            return;
        }
        Project project = puppetEntity.getProject();
        new Task.Backgroundable(project, PuppetBundle.message("puppet.installing.dependencies", puppetEntity.getDescriptiveName(), puppetEntity.getName()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PuppetDependencyManagerAdapter.this.installDependencies(puppetEntity, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter$1", "run"));
            }
        }.queue();
    }

    protected void doPostInstallationWork(@NotNull PuppetEntity puppetEntity, @Nullable Runnable additionalRunnable) {
        if (puppetEntity == null) {
            PuppetDependencyManagerAdapter.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = puppetEntity.getProject();
        if (project.isDisposed()) {
            return;
        }
        VirtualFile entityRoot = puppetEntity.getRoot();
        if (!entityRoot.isValid()) {
            return;
        }
        entityRoot.refresh(true, true);
    }

    @NotNull
    public static List<PuppetDependencyManagerAdapter> getExtensions() {
        List<Object> list = Arrays.asList(EP_NAME.getExtensions());
        if (list == null) {
            PuppetDependencyManagerAdapter.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPostInstallationWork";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

