/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.ByteArrayUtils;
import org.jetbrains.annotations.NotNull;

public class SmartDeltaCompressor
implements IntList {
    private final int mySize;
    private final byte[] myDeltas;
    private final long[] myMajorBits;
    private final long[] myMinorBits;
    private final int[] myStrongIndexes;

    @NotNull
    public static SmartDeltaCompressor newInstance(@NotNull IntList deltaList) {
        if (deltaList == null) {
            SmartDeltaCompressor.$$$reportNull$$$0(0);
        }
        if (deltaList.size() < 0) {
            throw new NegativeArraySizeException("size < 0: " + deltaList.size());
        }
        int bytesAfterCompression = ByteArrayUtils.countBytesAfterCompression(deltaList);
        byte[] deltas = new byte[bytesAfterCompression];
        int size = deltaList.size();
        int groundPointCount = ByteArrayUtils.groundPointCount(size, 64);
        int[] groundIndexes = new int[groundPointCount];
        long[] majorBits = new long[groundPointCount];
        long[] minorBits = new long[groundPointCount];
        int offset = 0;
        for (int main = 0; main < groundPointCount; ++main) {
            int index;
            groundIndexes[main] = offset;
            for (int rem = 0; rem < 64 && (index = main * 64 + rem) < size; ++rem) {
                int sizeOf = ByteArrayUtils.sizeOf(deltaList.get(index));
                ByteArrayUtils.writeDelta(offset, deltaList.get(index), sizeOf, deltas);
                long mask = 1L << rem;
                if (sizeOf == 3 || sizeOf == 4) {
                    int n = main;
                    majorBits[n] = majorBits[n] | mask;
                }
                if (sizeOf == 2 || sizeOf == 4) {
                    int n = main;
                    minorBits[n] = minorBits[n] | mask;
                }
                offset += sizeOf;
            }
        }
        SmartDeltaCompressor smartDeltaCompressor = new SmartDeltaCompressor(size, deltas, majorBits, minorBits, groundIndexes);
        if (smartDeltaCompressor == null) {
            SmartDeltaCompressor.$$$reportNull$$$0(1);
        }
        return smartDeltaCompressor;
    }

    private SmartDeltaCompressor(int size, byte[] deltas, long[] majorBits, long[] minorBits, int[] strongIndexes) {
        this.mySize = size;
        this.myDeltas = deltas;
        this.myMajorBits = majorBits;
        this.myMinorBits = minorBits;
        this.myStrongIndexes = strongIndexes;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public int get(int index) {
        int main = index >>> 6;
        int rem = index & 0x3F;
        int shift = 63 - rem;
        long major = this.myMajorBits[main] << shift;
        long minor = this.myMinorBits[main] << shift;
        int sizeOf = (int)(2L * (major >>> 63) + (minor >>> 63) + 1L);
        int endIndex = this.myStrongIndexes[main] + 2 * Long.bitCount(major) + Long.bitCount(minor) + rem + 1;
        return ByteArrayUtils.readDelta(endIndex - sizeOf, sizeOf, this.myDeltas);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deltaList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/impl/SmartDeltaCompressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/SmartDeltaCompressor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

