/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEntityRefImpl
extends XmlElementImpl
implements XmlEntityRef {
    @NonNls
    private static final String GT_ENTITY = "&gt;";
    @NonNls
    private static final String QUOT_ENTITY = "&quot;";
    private static final Key<Boolean> DISABLE_ENTITY_EXPAND = Key.create((String)"disable.entity.expand");

    public XmlEntityRefImpl() {
        super(XmlElementType.XML_ENTITY_REF);
    }

    public XmlEntityDecl resolve(PsiFile targetFile) {
        String text = this.getText();
        if (text.equals(GT_ENTITY) || text.equals(QUOT_ENTITY)) {
            return null;
        }
        return XmlEntityRefImpl.resolveEntity(this, text, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl resolveEntity(XmlElement element, String text, PsiFile targetFile) {
        CachedValue value;
        XmlDocument document;
        if (targetFile instanceof XmlFile && (document = ((XmlFile)targetFile).getDocument()) != null && document.getUserData(DISABLE_ENTITY_EXPAND) != null) {
            return null;
        }
        String entityName = text.substring(1, text.length() - 1);
        PsiFile targetElement = targetFile != null ? targetFile : element;
        Object object = XmlEntityCache.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> map = XmlEntityCache.getCachingMap((PsiElement)targetElement);
            value = map.get(entityName);
            PsiFile containingFile = element.getContainingFile();
            if (value == null) {
                PsiManager manager = element.getManager();
                if (manager == null) {
                    return (XmlEntityDecl)XmlEntityRefImpl.doResolveEntity((PsiElement)targetElement, entityName, containingFile).getValue();
                }
                value = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> XmlEntityRefImpl.lambda$resolveEntity$0((PsiElement)targetElement, entityName, containingFile));
                map.put(entityName, (CachedValue<XmlEntityDecl>)value);
            }
        }
        return (XmlEntityDecl)value.getValue();
    }

    private static CachedValueProvider.Result<XmlEntityDecl> doResolveEntity(final PsiElement targetElement, final String entityName, final PsiFile contextFile) {
        return (CachedValueProvider.Result)RecursionManager.doPreventingRecursion((Object)targetElement, (boolean)true, (Computable)new Computable<CachedValueProvider.Result<XmlEntityDecl>>(){

            public CachedValueProvider.Result<XmlEntityDecl> compute() {
                final ArrayList<Object> deps = new ArrayList<Object>();
                final XmlEntityDecl[] result2 = new XmlEntityDecl[]{null};
                PsiElementProcessor processor2 = new PsiElementProcessor(){

                    public boolean execute(@NotNull PsiElement element) {
                        XmlEntityDecl entityDecl;
                        String declName;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof XmlDoctype) {
                            XmlMarkupDecl markupDecl;
                            XmlDoctype xmlDoctype = (XmlDoctype)element;
                            String dtdUri = XmlEntityRefImpl.getDtdForEntity(xmlDoctype);
                            if (dtdUri != null) {
                                XmlFile file2 = XmlUtil.getContainingFile(element);
                                if (file2 == null) {
                                    return true;
                                }
                                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)file2, dtdUri);
                                if (xmlFile != null && xmlFile != targetElement) {
                                    deps.add(xmlFile);
                                    if (!XmlUtil.processXmlElements((XmlElement)xmlFile, this, true)) {
                                        return false;
                                    }
                                }
                            }
                            if ((markupDecl = xmlDoctype.getMarkupDecl()) != null && !XmlUtil.processXmlElements((XmlElement)markupDecl, this, true)) {
                                return false;
                            }
                        } else if (element instanceof XmlEntityDecl && StringUtil.equals((CharSequence)(declName = (entityDecl = (XmlEntityDecl)element).getName()), (CharSequence)entityName)) {
                            result2[0] = entityDecl;
                            return false;
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlEntityRefImpl$1$1", "execute"));
                    }
                };
                FileViewProvider provider = targetElement.getContainingFile().getViewProvider();
                deps.add(provider.getPsi(provider.getBaseLanguage()));
                boolean notfound = PsiTreeUtil.processElements((PsiElement)targetElement, (PsiElementProcessor)processor2);
                if (notfound && contextFile != targetElement && contextFile != null && contextFile.isValid()) {
                    notfound = PsiTreeUtil.processElements((PsiElement)contextFile, (PsiElementProcessor)processor2);
                }
                if (notfound && targetElement instanceof XmlFile && deps.size() == 1 && ((XmlFile)targetElement).getFileType() != DTDFileType.INSTANCE) {
                    XmlElementDescriptor descriptor;
                    XmlDocument document = ((XmlFile)targetElement).getDocument();
                    XmlTag rootTag = document != null ? document.getRootTag() : null;
                    XmlFile descriptorFile = null;
                    if (HtmlUtil.isHtml5Document(document)) {
                        descriptorFile = XmlUtil.findXmlFile((PsiFile)((XmlFile)targetElement), Html5SchemaProvider.getCharsDtdLocation());
                    } else if (rootTag != null && document.getUserData(DISABLE_ENTITY_EXPAND) == null && (descriptor = rootTag.getDescriptor()) != null && !(descriptor instanceof AnyXmlElementDescriptor)) {
                        PsiElement element = descriptor.getDeclaration();
                        PsiFile containingFile = element != null ? element.getContainingFile() : null;
                        XmlFile xmlFile = descriptorFile = containingFile instanceof XmlFile ? (XmlFile)containingFile : null;
                    }
                    if (descriptorFile != null && !descriptorFile.getName().equals(((XmlFile)targetElement).getName() + ".dtd")) {
                        deps.add(descriptorFile);
                        XmlUtil.processXmlElements((XmlElement)descriptorFile, processor2, true);
                    }
                }
                return new CachedValueProvider.Result((Object)result2[0], ArrayUtil.toObjectArray(deps));
            }
        });
    }

    private static String getDtdForEntity(XmlDoctype xmlDoctype) {
        return HtmlUtil.isHtml5Doctype(xmlDoctype) ? Html5SchemaProvider.getCharsDtdLocation() : XmlUtil.getDtdUri(xmlDoctype);
    }

    public XmlTag getParentTag() {
        XmlElement parent = (XmlElement)this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (psiReferenceArray == null) {
            XmlEntityRefImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlEntityRefImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlElement((XmlElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public static void setNoEntityExpandOutOfDocument(XmlDocument doc, boolean b) {
        if (b) {
            doc.putUserData(DISABLE_ENTITY_EXPAND, (Object)Boolean.TRUE);
        } else {
            doc.putUserData(DISABLE_ENTITY_EXPAND, null);
        }
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$resolveEntity$0(PsiElement targetElement, String entityName, PsiFile containingFile) {
        return XmlEntityRefImpl.doResolveEntity(targetElement, entityName, containingFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlEntityRefImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlEntityRefImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

