/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssComposesClassReference
extends CssClassOrIdReference {
    public CssComposesClassReference(PsiElement element) {
        super(element, null);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    protected boolean isId() {
        return false;
    }

    @Override
    protected GlobalSearchScope getSearchScope() {
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiFile containingFile = this.myElement.getContainingFile().getOriginalFile();
        if (lastTerm.getTermType() == CssTermTypes.STRING) {
            Object[] psiFiles = CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild());
            return GlobalSearchScope.filesScope((Project)this.myElement.getProject(), (Collection)ContainerUtil.map((Object[])psiFiles, PsiFile::getVirtualFile));
        }
        return GlobalSearchScope.fileScope((PsiFile)containingFile);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = this.getSearchScope();
        ArrayList result = ContainerUtil.newArrayList();
        Collection<String> notAllowed = this.getNotAllowedCompletionClassNames();
        CssIndexUtil.processAllClassNamesInScope(project, scope, (Processor<? super String>)((Processor)name -> {
            if (!notAllowed.contains(name)) {
                result.add(LookupElementBuilder.create((String)name).withIcon(AllIcons.Xml.Css_class));
            }
            return true;
        }));
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
        if (objectArray == null) {
            CssComposesClassReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    private Collection<String> getNotAllowedCompletionClassNames() {
        boolean isLocal;
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CssComposesClassReference.$$$reportNull$$$0(1);
            }
            return set;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, CssRuleset.class);
        if (ruleset == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CssComposesClassReference.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet notAllowed = ContainerUtil.newHashSet();
        boolean bl = isLocal = lastTerm.getTermType() != CssTermTypes.STRING;
        if (isLocal) {
            List elements = SyntaxTraverser.psiTraverser((PsiElement)ruleset.getSelectorList()).filter(CssClass.class).map(CssSelectorSuffix::getName).toList();
            notAllowed.addAll(elements);
        }
        if (ruleset.getBlock() != null) {
            List classesFromSameFile = Arrays.stream(ruleset.getBlock().getDeclarations()).filter(d -> CssComposesClassReference.isComposesDeclarationWithSamePath(d, isLocal ? null : lastTerm.getText())).flatMap(d -> CssComposesClassReference.getClassNames(d, isLocal)).collect(Collectors.toList());
            notAllowed.addAll(classesFromSameFile);
        }
        HashSet hashSet = notAllowed;
        if (hashSet == null) {
            CssComposesClassReference.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static Stream<String> getClassNames(@NotNull CssDeclaration declaration, boolean isLocal) {
        if (declaration == null) {
            CssComposesClassReference.$$$reportNull$$$0(4);
        }
        if (declaration.getValue() == null) {
            return Stream.empty();
        }
        CssTerm[] terms = declaration.getValue().getTerms();
        ArrayList classNames = ContainerUtil.newArrayList();
        int lastIndex = terms.length - (isLocal ? 0 : 2);
        for (int i = 0; i < lastIndex; ++i) {
            classNames.add(terms[i].getText());
        }
        return classNames.stream();
    }

    private static boolean isComposesDeclarationWithSamePath(@NotNull CssDeclaration declaration, @Nullable String path) {
        if (declaration == null) {
            CssComposesClassReference.$$$reportNull$$$0(5);
        }
        if (!CssPropertyUtil.isComposesProperty(declaration)) {
            return false;
        }
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(declaration);
        if (lastTerm == null) {
            return false;
        }
        if (path == null && lastTerm.getTermType() != CssTermTypes.STRING) {
            return true;
        }
        return path != null && lastTerm.textMatches((CharSequence)path);
    }

    @Nullable
    private static CssTerm getDeclarationLastTerm(@Nullable CssDeclaration declaration) {
        if (declaration == null || declaration.getValue() == null) {
            return null;
        }
        return (CssTerm)ArrayUtil.getLastElement((Object[])declaration.getValue().getTerms());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssComposesClassReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotAllowedCompletionClassNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssComposesClassReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComposesDeclarationWithSamePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

