/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.findUsages.JavaScriptGroupRuleProviderBase;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usages.PsiNamedElementUsageGroupBase;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class JavaScriptFunctionGroupRuleProvider
extends JavaScriptGroupRuleProviderBase<JSFunction> {
    @Override
    protected Class<? extends JSNamedElement> getUsageClass() {
        return JSFunction.class;
    }

    @Override
    protected UsageGroup createUsageGroup(JSFunction jsFunction) {
        PsiElement context;
        String name = jsFunction.getName();
        if (name == null && (context = jsFunction.getContainingFile().getContext()) != null) {
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
            if (parent == null) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
            }
            if (parent != null) {
                return new PsiNamedElementUsageGroupBase(parent, PlatformIcons.XML_TAG_ICON);
            }
        }
        return new FunctionUsageGroup(jsFunction);
    }

    @Override
    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        UsageGroup usageGroupForElement = super.createUsageGroupForElement(psiElement);
        if (usageGroupForElement == null) {
            usageGroupForElement = (UsageGroup)ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(psiElement, jsFunctionExpression -> this.createUsageGroup((JSFunction)jsFunctionExpression));
        }
        return usageGroupForElement;
    }

    private static class FunctionUsageGroup
    extends PsiNamedElementUsageGroupBase<JSFunction> {
        private String myAnonymousName;

        FunctionUsageGroup(@NotNull JSFunction function) {
            if (function == null) {
                FunctionUsageGroup.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)function, PlatformIcons.METHOD_ICON);
            String name = super.getPresentableName();
            if (JSFormatUtil.ANONYMOUS_ELEMENT_PRESENTATION.equals(name)) {
                JSFunction current = function;
                while (current != null && this.myAnonymousName == null) {
                    current = current.getParent();
                    JSQualifiedNamedElement qualifier = null;
                    if (current instanceof JSQualifiedNamedElement) {
                        qualifier = (JSQualifiedNamedElement)current;
                    } else if (current instanceof JSAssignmentExpression) {
                        qualifier = ((JSAssignmentExpression)current).getDefinitionExpression();
                    }
                    this.myAnonymousName = qualifier != null ? name + " in " + qualifier.getQualifiedName() : null;
                }
            }
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.getPresentableName();
            if (string == null) {
                FunctionUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPresentableName() {
            String name = super.getPresentableName();
            if (JSFormatUtil.ANONYMOUS_ELEMENT_PRESENTATION.equals(name) && this.myAnonymousName != null) {
                String string = this.myAnonymousName;
                if (string == null) {
                    FunctionUsageGroup.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = name;
            if (string == null) {
                FunctionUsageGroup.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

