/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvailablePackageVersions {
    public static final String LATEST_DIST_TAG = "latest";
    private static final Logger LOG = Logger.getInstance(AvailablePackageVersions.class);
    private static final Comparator<SemVer> VERSION_DESC = (v1, v2) -> {
        int r = v1.compareTo(v2);
        if (r == 0) {
            r = v1.getRawVersion().compareTo(v2.getRawVersion());
        }
        return -r;
    };
    private final List<SemVer> myVersions;
    private final List<Pair<String, SemVer>> myDistTags;

    public AvailablePackageVersions(@NotNull List<SemVer> versions, @NotNull List<Pair<String, SemVer>> distTags) {
        if (versions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(0);
        }
        if (distTags == null) {
            AvailablePackageVersions.$$$reportNull$$$0(1);
        }
        this.myVersions = ImmutableList.sortedCopyOf(VERSION_DESC, versions);
        this.myDistTags = ImmutableList.sortedCopyOf(Comparator.comparing(pair -> (SemVer)pair.second, VERSION_DESC), distTags);
    }

    @NotNull
    public List<SemVer> getVersions() {
        List<SemVer> list = this.myVersions;
        if (list == null) {
            AvailablePackageVersions.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<Pair<String, SemVer>> getDistTags() {
        List<Pair<String, SemVer>> list = this.myDistTags;
        if (list == null) {
            AvailablePackageVersions.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public SemVer findVersionByDistTag(@NotNull String distTagName) {
        if (distTagName == null) {
            AvailablePackageVersions.$$$reportNull$$$0(4);
        }
        for (Pair<String, SemVer> tag : this.myDistTags) {
            if (!distTagName.equals(tag.getFirst())) continue;
            return (SemVer)tag.getSecond();
        }
        return null;
    }

    @Nullable
    public String findDistTagByVersion(@NotNull SemVer version) {
        if (version == null) {
            AvailablePackageVersions.$$$reportNull$$$0(5);
        }
        return this.myDistTags.stream().filter(pair -> {
            if (version == null) {
                AvailablePackageVersions.$$$reportNull$$$0(16);
            }
            return version.getRawVersion().equals(((SemVer)pair.second).getRawVersion());
        }).map(pair -> (String)pair.first).findFirst().orElse(null);
    }

    @NotNull
    public static AvailablePackageVersions parseFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(6);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            AvailablePackageVersions availablePackageVersions = new AvailablePackageVersions(Collections.emptyList(), Collections.emptyList());
            if (availablePackageVersions == null) {
                AvailablePackageVersions.$$$reportNull$$$0(7);
            }
            return availablePackageVersions;
        }
        reader.beginObject();
        List<Pair<String, SemVer>> distTags = Collections.emptyList();
        List<SemVer> versions = Collections.emptyList();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("dist-tags".equals(name)) {
                distTags = AvailablePackageVersions.readDistTags(reader);
                continue;
            }
            if ("versions".equals(name)) {
                versions = AvailablePackageVersions.readVersions(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        AvailablePackageVersions availablePackageVersions = new AvailablePackageVersions(versions, distTags);
        if (availablePackageVersions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(8);
        }
        return availablePackageVersions;
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(9);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                AvailablePackageVersions.$$$reportNull$$$0(10);
            }
            return list;
        }
        reader.beginObject();
        ArrayList distTags = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = JsonUtil.nextStringOrSkip((JsonReader)reader);
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            distTags.add(Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
        ArrayList arrayList = distTags;
        if (arrayList == null) {
            AvailablePackageVersions.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<SemVer> readVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(12);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<SemVer> list = Collections.emptyList();
            if (list == null) {
                AvailablePackageVersions.$$$reportNull$$$0(13);
            }
            return list;
        }
        reader.beginObject();
        ArrayList versions = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String name = reader.nextName();
            reader.skipValue();
            SemVer version = SemVer.parseFromText((String)name);
            if (version == null) continue;
            versions.add(version);
        }
        reader.endObject();
        ArrayList arrayList = versions;
        if (arrayList == null) {
            AvailablePackageVersions.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static AvailablePackageVersions createEmpty() {
        AvailablePackageVersions availablePackageVersions = new AvailablePackageVersions(Collections.emptyList(), Collections.emptyList());
        if (availablePackageVersions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(15);
        }
        return availablePackageVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTags";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTagName";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistTags";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFromPackageMetadata";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readDistTags";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readVersions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVersionByDistTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDistTagByVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseFromPackageMetadata";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readVersions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDistTagByVersion$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

