/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SoftArrayHashMap<T, V>
implements Cloneable {
    private Map<T, SoftArrayHashMap<T, V>> myContinuationMap;
    private Map<T, V> myValuesMap;
    private V myEmptyValue;
    private final TObjectHashingStrategy<T> myStrategy;

    public SoftArrayHashMap() {
        this(ContainerUtil.canonicalStrategy());
    }

    public SoftArrayHashMap(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            SoftArrayHashMap.$$$reportNull$$$0(0);
        }
        this.myStrategy = strategy;
    }

    private V get(T[] array, int index) {
        SoftArrayHashMap<T, V> map;
        if (index == array.length - 1) {
            return this.myValuesMap != null ? (V)this.myValuesMap.get(array[index]) : null;
        }
        if (this.myContinuationMap != null && (map = this.myContinuationMap.get(array[index])) != null) {
            return super.get(array, index + 1);
        }
        return null;
    }

    public final V get(T[] key) {
        if (key.length == 0) {
            return this.myEmptyValue;
        }
        return this.get(key, 0);
    }

    public boolean processLeafEntries(PairProcessor<T, V> processor) {
        if (this.myValuesMap != null) {
            for (Object object : this.myValuesMap.keySet()) {
                if (processor.process(object, this.myValuesMap.get(object))) continue;
                return false;
            }
        }
        if (this.myContinuationMap != null) {
            for (SoftArrayHashMap softArrayHashMap : this.myContinuationMap.values()) {
                if (softArrayHashMap.processLeafEntries(processor)) continue;
                return false;
            }
        }
        return true;
    }

    private void put(T[] array, int index, V value) {
        T key = array[index];
        if (index == array.length - 1) {
            if (this.myValuesMap == null) {
                this.myValuesMap = ContainerUtil.createSoftMap(this.myStrategy);
            }
            this.myValuesMap.put(key, value);
        } else {
            SoftArrayHashMap<T, V> softArrayHashMap;
            if (this.myContinuationMap == null) {
                this.myContinuationMap = ContainerUtil.createSoftMap(this.myStrategy);
            }
            if ((softArrayHashMap = this.myContinuationMap.get(key)) == null) {
                softArrayHashMap = new SoftArrayHashMap<T, V>(this.myStrategy);
                this.myContinuationMap.put(key, softArrayHashMap);
            }
            super.put(array, index + 1, value);
        }
    }

    public final void put(T[] key, V value) {
        if (key.length == 0) {
            this.myEmptyValue = value;
        } else {
            this.put(key, 0, value);
        }
    }

    public final void clear() {
        this.myContinuationMap = null;
        this.myValuesMap = null;
        this.myEmptyValue = null;
    }

    public final boolean containsKey(T[] path) {
        return this.get(path) != null;
    }

    public final SoftArrayHashMap<T, V> clone() {
        SoftArrayHashMap<T, V> copy = new SoftArrayHashMap<T, V>(this.myStrategy);
        copy.myContinuationMap = this.copyMap(this.myContinuationMap);
        copy.myValuesMap = this.copyMap(this.myValuesMap);
        copy.myEmptyValue = this.myEmptyValue;
        return copy;
    }

    private <X> Map<T, X> copyMap(Map<T, X> map) {
        Map<T, X> copy = ContainerUtil.createSoftMap();
        for (Map.Entry<T, X> entry : map.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/SoftArrayHashMap", "<init>"));
    }
}

