/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;

public class RubyRemoteProcessHandler
extends ColoredRemoteProcessHandler<SshExecProcess>
implements RubyProcessHandlerEx {
    private static final Logger LOG = Logger.getInstance(RubyRemoteProcessHandler.class);
    private final List<PortForwarding> myRegisteredForwardings;

    public RubyRemoteProcessHandler(@NotNull SshExecProcess process, @NotNull String commandLine) {
        if (process == null) {
            RubyRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RubyRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        super((RemoteProcess)process, commandLine, null);
        this.myRegisteredForwardings = Lists.newCopyOnWriteArrayList();
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyRemoteProcessHandler.this.removeTunnels((SshExecProcess)RubyRemoteProcessHandler.this.getProcess(), "processTerminated");
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                RubyRemoteProcessHandler.this.removeTunnels((SshExecProcess)RubyRemoteProcessHandler.this.getProcess(), "processWillTerminate");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteProcessHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void removeTunnels(@Nullable SshExecProcess process, @NotNull String event) {
        if (event == null) {
            RubyRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        if (process == null) {
            return;
        }
        ArrayList localForwardings = Lists.newArrayList(this.myRegisteredForwardings);
        this.myRegisteredForwardings.clear();
        for (PortForwarding forwarding : localForwardings) {
            if (forwarding.getDirection() != PortForwarding.Direction.REMOTE_TO_LOCAL) continue;
            try {
                LOG.info(event + ": removing port forwarding - " + forwarding);
                process.removeLocalTunnel(forwarding.getLocalPort());
            }
            catch (RemoteSdkException e) {
                LOG.info("Unable to remove port forwarding", (Throwable)e);
            }
        }
    }

    public void addTunnel(@NotNull PortForwarding portForwarding) throws ExecutionException {
        if (portForwarding == null) {
            RubyRemoteProcessHandler.$$$reportNull$$$0(3);
        }
        LOG.info("Adding new tunnel - " + portForwarding);
        switch (portForwarding.getDirection()) {
            case REMOTE_TO_LOCAL: {
                ((SshExecProcess)this.getProcess()).addLocalTunnel(portForwarding.getLocalPort(), portForwarding.getRemotePort());
                break;
            }
            case LOCAL_TO_REMOTE: {
                ((SshExecProcess)this.getProcess()).addRemoteTunnel(portForwarding.getRemotePort(), portForwarding.getLocalHostName(), portForwarding.getLocalPort());
                break;
            }
            default: {
                assert (false) : "Unexpected port forwarding direction " + portForwarding.getDirection();
                break;
            }
        }
        this.myRegisteredForwardings.add(portForwarding);
    }

    public int addTunnelForRemoteServer(int remotePort) throws ExecutionException {
        try {
            int localPort = NetUtils.findAvailableSocketPort();
            this.addTunnel(PortForwarding.remoteToLocal((String)"127.0.0.1", (int)remotePort, (int)localPort));
            return localPort;
        }
        catch (IOException e) {
            throw new ExecutionException("Unable to find local free socket.", (Throwable)e);
        }
    }

    @Nullable
    public String getCommandLine() {
        return this.myCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portForwarding";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTunnels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTunnel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

