/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.layout.router.polyline;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YRectangle;

public interface Interval {
    public double getMin();

    public double getMax();

    public double getCenter();

    public boolean contains(double var1);

    public double getSize();

    public boolean intersects(Interval var1);

    public boolean intersects(Interval var1, double var2);

    public double distanceTo(double var1);

    public double distanceTo(Interval var1);

    public boolean coveredBy(Interval var1);

    public boolean coveredBy(Interval var1, double var2);

    public double getClosest(double var1);

    public boolean isLessThan(Interval var1);

    public boolean isGreaterThan(Interval var1);

    public String toString();

    public boolean hasSameRange(Interval var1);

    public boolean hasSameRange(Interval var1, double var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static class Statics {
        public static Interval calculateIntersection(Interval interval, Interval interval1) {
            return GraphManager.getGraphManager()._Interval_calculateIntersection(interval, interval1);
        }

        public static Interval calculateUnion(Interval interval, Interval interval1) {
            return GraphManager.getGraphManager()._Interval_calculateUnion(interval, interval1);
        }

        public static Interval calculateUnion(Interval interval, double v) {
            return GraphManager.getGraphManager()._Interval_calculateUnion(interval, v);
        }

        public static Interval calculateBridge(Interval interval, Interval interval1) {
            return GraphManager.getGraphManager()._Interval_calculateBridge(interval, interval1);
        }

        public static YRectangle calculateSpanningRectangle(Interval interval, Interval interval1) {
            return GraphManager.getGraphManager()._Interval_calculateSpanningRectangle(interval, interval1);
        }
    }
}

