/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class GherkinBrokenTableInspection
extends GherkinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(0);
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                List<GherkinExamplesBlock> examples = outline.getExamplesBlocks();
                for (GherkinExamplesBlock block : examples) {
                    if (block.getTable() == null) continue;
                    GherkinBrokenTableInspection.checkTable(block.getTable(), holder);
                }
            }

            @Override
            public void visitStep(GherkinStep step) {
                GherkinTable table = (GherkinTable)PsiTreeUtil.getChildOfType((PsiElement)step, GherkinTable.class);
                if (table != null) {
                    GherkinBrokenTableInspection.checkTable(table, holder);
                }
            }
        };
        if (gherkinElementVisitor == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(1);
        }
        return gherkinElementVisitor;
    }

    private static void checkTable(@NotNull GherkinTable table, @NotNull ProblemsHolder holder) {
        if (table == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(3);
        }
        GherkinTableRow header = table.getHeaderRow();
        for (GherkinTableRow row : table.getDataRows()) {
            if (header == null) {
                header = row;
            }
            if (row.getPsiCells().size() == header.getPsiCells().size()) continue;
            holder.registerProblem((PsiElement)row, CucumberBundle.message("inspection.gherkin.table.is.broken.row.error.message", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("inspection.gherkin.table.is.broken.name", new Object[0]);
        if (string == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GherkinBrokenTableInspection" == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(5);
        }
        return "GherkinBrokenTableInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

