/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.credentialStore.Credentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialsDeployable
extends ServerDeployableWithTempCredentials {
    public CredentialsDeployable() {
        this(null);
    }

    public CredentialsDeployable(@Nullable RemoteCredentials data) {
        super(new WebServerConfig());
        if (data != null) {
            this.initFrom(data);
        }
    }

    private void initFrom(RemoteCredentials data) {
        this.myServer.getFileTransferConfig().setAccessType(AccessType.SFTP);
        this.myServer.getFileTransferConfig().setHost(data.getHost());
        this.myServer.getFileTransferConfig().setLiteralPort(data.getLiteralPort());
        this.myServer.getFileTransferConfig().setAnonymous(false);
        this.myServer.getFileTransferConfig().setAuthType(data.getAuthType());
        this.myServer.getFileTransferConfig().setPrivateKeyFile(data.getPrivateKeyFile());
        this.myCredentials = CredentialsDeployable.createCredentials(data);
    }

    @NotNull
    private static Credentials createCredentials(@NotNull RemoteCredentials data) {
        if (data == null) {
            CredentialsDeployable.$$$reportNull$$$0(0);
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                Credentials credentials = new Credentials(data.getUserName(), data.getPassword());
                if (credentials == null) {
                    CredentialsDeployable.$$$reportNull$$$0(1);
                }
                return credentials;
            }
            case KEY_PAIR: {
                Credentials credentials = new Credentials(data.getUserName(), data.getPassphrase());
                if (credentials == null) {
                    CredentialsDeployable.$$$reportNull$$$0(2);
                }
                return credentials;
            }
        }
        Credentials credentials = new Credentials(data.getUserName(), (String)null);
        if (credentials == null) {
            CredentialsDeployable.$$$reportNull$$$0(3);
        }
        return credentials;
    }

    public String toString() {
        return "CredentialsDeployable{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + '}';
    }

    public void setName(String name) {
        this.myServer.setName(name);
    }

    public void setId(String id) {
        this.myServer.setId(id);
    }

    public void resetCredentials(@NotNull RemoteSdkCredentials credentials) {
        if (credentials == null) {
            CredentialsDeployable.$$$reportNull$$$0(4);
        }
        this.initFrom((RemoteCredentials)credentials);
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.myServer.setIsProjectLevel(isProjectLevel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/CredentialsDeployable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/CredentialsDeployable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCredentials";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

