/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client.header;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpHeaderDocumentation {
    private static final String CC_LICENCE = " is licensed under <a href=\"https://creativecommons.org/licenses/by-sa/2.5/\">CC-BY-SA 2.5</a>.";
    private static final String URL_PREFIX = "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/";
    private static final String RFC_PREFIX = "https://tools.ietf.org/html/rfc";
    private final String myName;
    private final String myRfc;
    private final String myRfcTitle;
    private final String myDescription;
    private final boolean myIsDeprecated;

    private HttpHeaderDocumentation(String name, String rfc, String rfcTitle, String description, boolean isDeprecated) {
        this.myName = name;
        this.myRfc = rfc;
        this.myRfcTitle = rfcTitle;
        this.myDescription = description;
        this.myIsDeprecated = isDeprecated;
    }

    @Nullable
    public static HttpHeaderDocumentation read(@NotNull JsonObject obj) {
        String name;
        if (obj == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)(name = HttpHeaderDocumentation.getAsString(obj, "name")))) {
            String rfcTitle = HttpHeaderDocumentation.getAsString(obj, "rfc-title");
            String rfcRef = HttpHeaderDocumentation.getAsString(obj, "rfc-ref");
            String descr = HttpHeaderDocumentation.getAsString(obj, "descr");
            JsonElement obsolete = obj.get("obsolete");
            boolean isObsolete = obsolete != null && obsolete.isJsonPrimitive() && obsolete.getAsBoolean();
            return new HttpHeaderDocumentation(name, rfcRef, rfcTitle, descr, isObsolete);
        }
        return null;
    }

    @NotNull
    private static String getAsString(@NotNull JsonObject obj, @NotNull String name) {
        JsonElement element;
        if (obj == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(1);
        }
        if (name == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(2);
        }
        String string = (element = obj.get(name)) != null && element.isJsonPrimitive() ? element.getAsString() : "";
        if (string == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String generateDoc() {
        if (StringUtil.isNotEmpty((String)this.myDescription)) {
            StringBuilder out = new StringBuilder().append(this.myDescription);
            if (StringUtil.isNotEmpty((String)this.myRfc) && StringUtil.isNotEmpty((String)this.myRfcTitle)) {
                out.append("<br/><br/>");
                out.append("<a href=\"").append(RFC_PREFIX).append(this.myRfc).append("\">").append(this.myRfcTitle).append("</a>");
            }
            String url = this.getUrl();
            out.append("<br/><br/>");
            out.append("<a href=\"").append(url).append("\">").append(this.getName()).append("</a> by ");
            out.append("<a href=\"").append(url).append("$history").append("\">").append("Mozilla Contributors").append("</a>");
            out.append(CC_LICENCE);
            return out.toString();
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isDeprecated() {
        return this.myIsDeprecated;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = URL_PREFIX + this.getName();
        if (string == null) {
            HttpHeaderDocumentation.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/header/HttpHeaderDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/header/HttpHeaderDocumentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

