/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceUpdateQueue;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SqlDataSourceStorage", storages={@Storage(value="sqlDataSources.xml")})
public class SqlDataSourceStorage
implements PersistentStateComponent<State> {
    private final Project myProject;
    final SqlDataSourceUpdateQueue myQueue;
    private final List<SqlDataSourceImpl> myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();

    public static SqlDataSourceStorage getInstance(Project project) {
        return (SqlDataSourceStorage)ServiceManager.getService((Project)project, SqlDataSourceStorage.class);
    }

    public SqlDataSourceStorage(Project project, DataSourceStorage.Prj dataSourceManager) {
        this.myProject = project;
        this.myQueue = new SqlDataSourceUpdateQueue(project);
    }

    public State getState() {
        State state = new State();
        for (SqlDataSourceImpl dataSource : this.myDataSources) {
            state.dataSources.add(dataSource.getState());
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(0);
        }
        this.myDataSources.clear();
        for (SqlDataSourceImpl.State dataSourceState : state.dataSources) {
            SqlDataSourceImpl dataSource = new SqlDataSourceImpl(DasUtil.NO_NAME, this.myProject, null);
            dataSource.loadState(dataSourceState);
            this.addDataSource(dataSource);
        }
    }

    public List<SqlDataSourceImpl> getDataSources() {
        return new ArrayList<SqlDataSourceImpl>(this.myDataSources);
    }

    public void removeDataSource(SqlDataSourceImpl dataSource) {
        this.myDataSources.remove(dataSource);
        dataSource.onRemovedFromStorage();
    }

    public void addDataSource(SqlDataSourceImpl dataSource) {
        dataSource.init();
        dataSource.onAddedToStorage();
        this.myDataSources.add(dataSource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/database/SqlDataSourceStorage", "loadState"));
    }

    public static class State {
        public List<SqlDataSourceImpl.State> dataSources = new ArrayList<SqlDataSourceImpl.State>();
    }
}

