/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"hasInterleavedSortKey", "", "Lcom/intellij/database/dialects/redshift/model/RsTable;", "isDefaultEncoding", "Lcom/intellij/database/dialects/redshift/model/RsTableColumn;", "isLzo", "isRaw", "isRawEncodingDataType", "intellij.database.dialects"})
public final class RsModelFunKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultEncoding(@NotNull RsTableColumn $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.getTable() == null) return true;
        if (Intrinsics.areEqual((Object)$receiver.getEncoding(), (Object)"none")) return true;
        if ($receiver.getEncoding() == null) {
            return true;
        }
        if (RsModelFunKt.isRaw($receiver)) {
            RsTable rsTable = $receiver.getTable();
            if (rsTable == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)rsTable, (String)"table!!");
            if (rsTable.isTemporary()) return true;
            if ($receiver.getSortKeyOrder() != 0) return true;
            if (RsModelFunKt.isRawEncodingDataType($receiver)) return true;
        }
        if (!RsModelFunKt.isLzo($receiver)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasInterleavedSortKey(@NotNull RsTable $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PositioningNamingFamily<? extends RsTableColumn> positioningNamingFamily = $receiver.getColumns();
        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"columns");
        Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            RsTableColumn rsTableColumn = (RsTableColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Integer n = v1.getSortKeyOrder();
            collection.add(n);
        }
        Integer minOrder = (Integer)CollectionsKt.min((Iterable)((List)destination$iv$iv));
        return minOrder != null && minOrder < 0;
    }

    private static final boolean isRaw(@NotNull RsTableColumn $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getEncoding(), (Object)"raw");
    }

    private static final boolean isLzo(@NotNull RsTableColumn $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getEncoding(), (Object)"lzo");
    }

    private static final boolean isRawEncodingDataType(@NotNull RsTableColumn $receiver) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)CollectionsKt.listOf((Object[])new String[]{"boolean", "double precision", "real"});
            for (Object t : iterable2) {
                String it = (String)t;
                if (!StringUtil.equalsIgnoreCase((CharSequence)it, (CharSequence)$receiver.getDataType().typeName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }
}

