/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociationsCallTypes;
import org.jetbrains.plugins.ruby.mongoid.MongoidCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class AssociationsUtil {
    @NonNls
    public static final String ASSOCIATION_NAME = "association.name";
    @NonNls
    public static final String ASSOCIATION_TYPE = "association.type";
    @NonNls
    public static final String ASSOCIATION_CLASS_NAME = "association.class.name";
    @NonNls
    public static final String ASSOCIATION_THROUGH = "association.through";
    @NonNls
    public static final String ASSOCIATION_SOURCE = "association.through.source";
    public static final Set<RubyCallType<List<String>>> TYPES;
    private static final long a;

    private AssociationsUtil() {
    }

    @NotNull
    public static List<RCall> getAssociations(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            AssociationsUtil.a(0);
        }
        List<RCall> list2 = symbol.getAllDeclarations(invocationPoint).stream().flatMap(psiElement -> AssociationsUtil.getAssociations(psiElement).stream()).collect(Collectors.toList());
        if (list2 == null) {
            AssociationsUtil.a(1);
        }
        return list2;
    }

    @NotNull
    public static List<RCall> getAssociations(@Nullable PsiElement model) {
        if (!(model instanceof RClass)) {
            List<RCall> list2 = Collections.emptyList();
            if (list2 == null) {
                AssociationsUtil.a(2);
            }
            return list2;
        }
        RClass rClass = (RClass)model;
        ArrayList<RCall> arrayList = new ArrayList<RCall>();
        for (RPsiStructureElement rPsiStructureElement : rClass.getStructureElements()) {
            if (!AssociationsUtil.isAssociationCall((PsiElement)rPsiStructureElement) || AssociationsUtil.getAssociationName((RCall)rPsiStructureElement) == null) continue;
            arrayList.add((RCall)rPsiStructureElement);
        }
        ArrayList<RCall> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AssociationsUtil.a(3);
        }
        return arrayList2;
    }

    @Nullable
    public static RCall resolveToAssociationCall(@NotNull Symbol symbol, @NotNull String name, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            AssociationsUtil.a(4);
        }
        if (name == null) {
            AssociationsUtil.a(5);
        }
        return AssociationsUtil.getAssociations(symbol, invocationPoint).stream().filter(rCall -> {
            if (name == null) {
                AssociationsUtil.a(17);
            }
            return name.equals(AssociationsUtil.getAssociationName(rCall));
        }).findFirst().orElse(null);
    }

    @Nullable
    public static RCall resolveToAssociationCall(@NotNull RClass modelClass, @NotNull String name) {
        if (modelClass == null) {
            AssociationsUtil.a(6);
        }
        if (name == null) {
            AssociationsUtil.a(7);
        }
        return AssociationsUtil.getAssociations((PsiElement)modelClass).stream().filter(rCall -> {
            if (name == null) {
                AssociationsUtil.a(16);
            }
            return name.equals(AssociationsUtil.getAssociationName(rCall));
        }).findFirst().orElse(null);
    }

    @Nullable
    public static PsiElement resolveToAssociationName(@NotNull RClass modelClass, @NotNull String name) {
        if (modelClass == null) {
            AssociationsUtil.a(8);
        }
        if (name == null) {
            AssociationsUtil.a(9);
        }
        RCall rCall = AssociationsUtil.resolveToAssociationCall(modelClass, name);
        return (PsiElement)ObjectUtils.doIfNotNull((Object)rCall, AssociationsUtil::getAssociationNameElement);
    }

    @NotNull
    public static List<String> getAssociationsNames(@NotNull RClass modelClass) {
        if (modelClass == null) {
            AssociationsUtil.a(10);
        }
        ArrayList arrayList = new ArrayList(2);
        for (RCall rCall : AssociationsUtil.getAssociations((PsiElement)modelClass)) {
            String string = AssociationsUtil.getAssociationName(rCall);
            if (StringUtil.isEmpty((String)string)) continue;
            arrayList.add(string);
        }
        List<String> list2 = arrayList.isEmpty() ? Collections.emptyList() : arrayList;
        if (list2 == null) {
            AssociationsUtil.a(11);
        }
        return list2;
    }

    @Nullable
    public static RClass resolveToModel(@NotNull RCall association) {
        long l2 = a ^ 0x60566DB2843L;
        if (association == null) {
            AssociationsUtil.a(12);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode() || AssociationsUtil.isAssociationCall((PsiElement)association)) : association.getName() + " isn't association call, " + association.getContainingFile().getName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)association);
        if (module == null || !InflectorService.getInstance(module).isInflectorAvailable()) {
            return null;
        }
        return AssociationsUtil.a(association, new HashSet<RCall>());
    }

    @Nullable
    private static RClass a(RCall rCall, HashSet<RCall> hashSet) {
        String string;
        RPsiElement rPsiElement2;
        long l2 = a ^ 0x5FE97E7F04EL;
        if (hashSet.contains(rCall)) {
            return null;
        }
        hashSet.add(rCall);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        List list2 = rCall.getCallArguments().getElements();
        for (RPsiElement rPsiElement2 : list2) {
            string3 = string3 == null ? AssociationsUtil.a("through", rPsiElement2) : string3;
            string4 = string4 == null ? AssociationsUtil.a("source", rPsiElement2) : string4;
            string2 = string2 == null ? AssociationsUtil.a("class_name", rPsiElement2) : string2;
            string5 = string5 == null ? AssociationsUtil.a("polymorphic", rPsiElement2) : string4;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rCall);
        String string6 = AssociationsUtil.getAssociationName(rCall);
        if (string3 != null && AssociationsUtil.getAssociationType(rCall).allowsThrough()) {
            return AssociationsUtil.a(module, rCall, string3, string2, string4 == null ? string6 : string4, hashSet);
        }
        rPsiElement2 = AssociationsUtil.findModel(string2, module);
        if (rPsiElement2 == null && string3 == null && string2 == null && (rPsiElement2 = AssociationsUtil.findModel(string = AssociationsUtil.isSingularAssociation(rCall) ? NamingConventions.toCamelCase(string6) : AssociationsUtil.b(module, string6), module)) == null && AssociationType.BELONGS_TO == AssociationsUtil.getAssociationType(rCall) && Comparing.strEqual((String)"true", (String)string5)) {
            return AssociationsUtil.a(module, string6);
        }
        return rPsiElement2;
    }

    @Nullable
    private static RClass a(Module module, final String string) {
        VirtualFile[] virtualFileArray;
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp == null) {
            return null;
        }
        VirtualFile virtualFile = railsApp.getModelsRoot();
        if (virtualFile == null) {
            return null;
        }
        for (VirtualFile virtualFile2 : virtualFileArray = virtualFile.getChildren()) {
            if (!RubyVirtualFileScanner.isRubyFile(virtualFile2)) continue;
            RFile rFile = (RFile)PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile2);
            assert (rFile != null);
            final Ref ref = new Ref((Object)false);
            PsiCallable psiCallable = new PsiCallable(){
                private static final long a = la.a(-5117898897997493941L, -9013007844536349099L, MethodHandles.lookup().lookupClass()).a(126628989461230L);

                @Override
                public void processCall(RCallArguments arguments) {
                    String string3;
                    long l2 = a ^ 0x5C449187C80DL;
                    String string2 = arguments.getCommand();
                    if ((string2.equals("has_many") || string2.equals("has_one")) && (string3 = arguments.getOptionValue("as")) != null && string3.equals(string)) {
                        ref.set((Object)true);
                    }
                }
            };
            List<RClass> list2 = RContainerUtil.getTopLevelClasses((RContainer)rFile);
            for (RClass rClass : list2) {
                new RubyPsiInterpreter().interpret((PsiElement)rClass, psiCallable);
                if (!((Boolean)ref.get()).booleanValue()) continue;
                return rClass;
            }
        }
        return null;
    }

    @Nullable
    public static String singularize(Module module, String s2) {
        InflectorService inflectorService = InflectorService.getInstance(module);
        return inflectorService.isInflectorAvailable() ? inflectorService.singularize(s2) : null;
    }

    @Nullable
    private static String b(Module module, String string) {
        InflectorService inflectorService = InflectorService.getInstance(module);
        return inflectorService.isInflectorAvailable() ? inflectorService.classify(string) : null;
    }

    @Nullable
    private static RClass a(Module module, RCall rCall, String string, String string2, String string3, HashSet<RCall> hashSet) {
        RClass rClass = AssociationsUtil.a(module, rCall, string, string3, hashSet);
        return AssociationsUtil.a(module, rCall, string3, string2, hashSet, rClass);
    }

    @Nullable
    private static RClass a(Module module, RCall rCall, String string, String string2, HashSet<RCall> hashSet) {
        RClass rClass = AssociationsUtil.findModel(AssociationsUtil.b(module, string), module);
        if (rClass != null) {
            return rClass;
        }
        RClass rClass2 = RubyPsiUtil.getContainingRClass((PsiElement)rCall);
        return AssociationsUtil.a(module, rCall, string, string2, hashSet, rClass2);
    }

    @Nullable
    public static RClass findModel(@Nullable String modelName, @Nullable Module module) {
        VirtualFile virtualFile;
        if (modelName == null || module == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module);
        VirtualFile virtualFile2 = virtualFile = railsApp != null ? railsApp.getModelsRoot() : null;
        if (virtualFile == null) {
            return null;
        }
        boolean bl2 = modelName.contains(RNameUtilCore.SYMBOL_DELIMITER);
        FQN fQN = FQN.Builder.fromString((String)modelName);
        String string = fQN.getShortName();
        Project project = module.getProject();
        return (RClass)RubyClassModuleNameIndex.findOne(project, string, GlobalSearchScope.allScope((Project)project), rContainer -> {
            VirtualFile virtualFile2 = rContainer.getContainingFile().getVirtualFile();
            if (rContainer instanceof RClass && virtualFile2 != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)true)) {
                Symbol symbol;
                RClass rClass = (RClass)rContainer;
                return !bl2 || (symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass)) != null && symbol.getFQNWithNesting().equals(fQN);
            }
            return false;
        });
    }

    @Nullable
    private static RClass a(Module module, RCall rCall, String string, String string2, HashSet<RCall> hashSet, RClass rClass) {
        for (RCall rCall2 : AssociationsUtil.getAssociations((PsiElement)rClass)) {
            if (!AssociationsUtil.a(module, rCall, string2, string, rCall2)) continue;
            return AssociationsUtil.a(rCall2, hashSet);
        }
        return null;
    }

    private static boolean a(Module module, RCall rCall, String string, String string2, RCall rCall2) {
        RubyCallType rubyCallType = rCall.getCallType();
        RubyCallType rubyCallType2 = rCall2.getCallType();
        if (rubyCallType2 != rubyCallType && rubyCallType2 != RailsCallTypeProvider.BELONGS_TO_CALL) {
            return false;
        }
        boolean bl2 = Comparing.strEqual((String)string2, (String)AssociationsUtil.getAssociationName(rCall2));
        bl2 |= rubyCallType == RailsCallTypeProvider.HAS_MANY_CALL && Comparing.strEqual((String)AssociationsUtil.singularize(module, string2), (String)AssociationsUtil.getAssociationName(rCall2));
        return bl2 |= Comparing.strEqual((String)string, (String)AssociationsUtil.b(module, AssociationsUtil.getAssociationName(rCall2)));
    }

    @Nullable
    private static String a(@NonNls String string, RPsiElement rPsiElement) {
        if (rPsiElement instanceof RAssoc) {
            RAssoc rAssoc = (RAssoc)rPsiElement;
            RPsiElement rPsiElement2 = rAssoc.getKey();
            RPsiElement rPsiElement3 = rAssoc.getValue();
            if (rPsiElement2 == null || rPsiElement3 == null) {
                return null;
            }
            return Comparing.strEqual((String)string, (String)RubyPsiUtil.getElementText((PsiElement)rPsiElement2)) ? RubyPsiUtil.getElementText((PsiElement)rPsiElement3) : null;
        }
        return null;
    }

    public static boolean isSingularAssociation(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(13);
        }
        return AssociationsUtil.isSingularAssociation(AssociationsUtil.getAssociationType(association));
    }

    public static boolean isSingularAssociation(@NotNull AssociationType associationType) {
        if (associationType == null) {
            AssociationsUtil.a(14);
        }
        return AssociationsCallTypes.SINGULAR_ASSOCIATIONS.contains((Object)associationType);
    }

    public static boolean isPolymorphicAssociation(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(15);
        }
        return association.getArguments().stream().anyMatch(rPsiElement -> {
            long l2 = a ^ 0x41B79E9DD2F6L;
            return AssociationsUtil.a("polymorphic", rPsiElement) != null;
        });
    }

    public static AssociationType getAssociationType(RCall call) {
        RubyCallType rubyCallType = call.getCallType();
        if (rubyCallType == RailsCallTypeProvider.HAS_ONE_CALL) {
            return AssociationType.HAS_ONE;
        }
        if (rubyCallType == RailsCallTypeProvider.BELONGS_TO_CALL) {
            return AssociationType.BELONGS_TO;
        }
        if (rubyCallType == RailsCallTypeProvider.HAS_AND_BELONGS_TO_MANY_CALL) {
            return AssociationType.HAS_AND_BELONGS_TO_MANY;
        }
        if (rubyCallType == RailsCallTypeProvider.HAS_MANY_CALL) {
            return AssociationType.HAS_MANY;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDS_MANY) {
            return AssociationType.EMBEDS_MANY;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDS_ONE) {
            return AssociationType.EMBEDS_ONE;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDDED_IN) {
            return AssociationType.EMBEDDED_IN;
        }
        return AssociationType.UNDEFINED;
    }

    @Nullable
    public static String getAssociationName(RCall association) {
        if (!AssociationsUtil.isAssociationCall((PsiElement)association)) {
            return null;
        }
        return (String)ContainerUtil.getFirstItem((List)((List)association.getData(new RubyCallType[0])));
    }

    @Nullable
    public static RPsiElement getAssociationNameElement(RCall association) {
        if (!AssociationsUtil.isAssociationCall((PsiElement)association)) {
            return null;
        }
        return association.getCallArguments().getFirstElement();
    }

    public static boolean isAssociationCall(PsiElement element) {
        return element instanceof RCall && TYPES.contains(((RCall)element).getCallType());
    }

    static String createAssociationText(Map<String, String> params) {
        long l2 = a ^ 0x5AFB5092D620L;
        String string = params.get(ASSOCIATION_NAME);
        String string2 = params.get(ASSOCIATION_CLASS_NAME);
        String string3 = params.get(ASSOCIATION_THROUGH);
        String string4 = params.get(ASSOCIATION_SOURCE);
        AssociationType associationType = AssociationType.get(params.get(ASSOCIATION_TYPE));
        assert (string != null && associationType != AssociationType.UNDEFINED);
        assert (string2 != null && string3 == null || string2 == null);
        assert (associationType.allowsThrough() || !associationType.allowsThrough() && string3 == null);
        assert (string3 != null || string4 == null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)associationType);
        stringBuilder.append(" :");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(", :class_name => '").append(string2).append("'");
        } else if (string3 != null) {
            stringBuilder.append(", :through => :").append(string3);
            if (string4 != null) {
                stringBuilder.append(", :source => :").append(string4);
            }
        }
        return stringBuilder.toString();
    }

    static {
        a = la.a(7366414055324224863L, 2000251274076952124L, MethodHandles.lookup().lookupClass()).a(98829952492531L);
        TYPES = AssociationsCallTypes.TYPES;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x487C6C523CABL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "association";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associationType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociationsNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveToAssociationCall";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveToAssociationName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationsNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSingularAssociation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphicAssociation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveToAssociationCall$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveToAssociationCall$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

