/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSelectInContext
implements SelectInContext {
    private final Project myProject;
    private final VirtualFile myFile;
    private final FileEditorProvider myProvider;

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(1);
        }
        this(project, file, FileSelectInContext.getFileEditorProvider(project, file));
    }

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file, @Nullable FileEditorProvider provider) {
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myFile = file;
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            FileSelectInContext.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        return null;
    }

    @Override
    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return this.myProvider;
    }

    private static FileEditorProvider getFileEditorProvider(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorManager manager;
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(7);
        }
        return (manager = FileEditorManager.getInstance(project)) == null ? null : () -> {
            if (file == null) {
                FileSelectInContext.$$$reportNull$$$0(8);
            }
            return (FileEditor)ArrayUtil.getFirstElement((Object[])manager.openFile(file, false));
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileSelectInContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileSelectInContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileEditorProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileEditorProvider$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

