/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    private static final String UNIX_PTY_INIT = "unix.pty.init";
    private static final String UNIX_PTY_COLUMNS = "unix.pty.cols";
    private static final String UNIX_PTY_ROWS = "unix.pty.rows";
    private static final String WIN_PTY_COLUMNS = "win.pty.cols";
    private static final String WIN_PTY_ROWS = "win.pty.rows";
    public static final int MAX_COLUMNS = 2500;
    private boolean myUseCygwinLaunch;
    private boolean myConsoleMode;
    private int myInitialColumns;
    private int myInitialRows;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    public PtyCommandLine() {
        this.myConsoleMode = true;
        this.myInitialColumns = -1;
        this.myInitialRows = -1;
    }

    @Deprecated
    public void setUseCygwinLaunch(boolean useCygwinLaunch) {
        this.withUseCygwinLaunch(useCygwinLaunch);
    }

    @Deprecated
    public void setConsoleMode(boolean consoleMode) {
        this.withConsoleMode(consoleMode);
    }

    @Deprecated
    public void setInitialColumns(int initialColumns) {
        this.withInitialColumns(initialColumns);
    }

    @Deprecated
    public void setInitialRows(int initialRows) {
        this.withInitialRows(initialRows);
    }

    public PtyCommandLine withUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myUseCygwinLaunch = useCygwinLaunch;
        return this;
    }

    public PtyCommandLine withConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
        return this;
    }

    public PtyCommandLine withInitialColumns(int initialColumns) {
        this.myInitialColumns = initialColumns;
        return this;
    }

    public PtyCommandLine withInitialRows(int initialRows) {
        this.myInitialRows = initialRows;
        return this;
    }

    public PtyCommandLine(@NotNull List<String> command) {
        if (command == null) {
            PtyCommandLine.$$$reportNull$$$0(0);
        }
        super(command);
        this.myConsoleMode = true;
        this.myInitialColumns = -1;
        this.myInitialRows = -1;
    }

    public PtyCommandLine(@NotNull GeneralCommandLine original) {
        if (original == null) {
            PtyCommandLine.$$$reportNull$$$0(1);
        }
        super(original);
        this.myConsoleMode = true;
        this.myInitialColumns = -1;
        this.myInitialRows = -1;
        if (original instanceof PtyCommandLine) {
            this.myUseCygwinLaunch = ((PtyCommandLine)original).myUseCygwinLaunch;
            this.myConsoleMode = ((PtyCommandLine)original).myConsoleMode;
            this.myInitialColumns = ((PtyCommandLine)original).myInitialColumns;
            this.myInitialRows = ((PtyCommandLine)original).myInitialRows;
        }
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        Process process;
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(2);
        }
        try {
            process = this.startProcessWithPty(commands);
        }
        catch (Throwable t) {
            File logFile = PtyCommandLine.getPtyLogFile();
            if (logFile != null && logFile.exists()) {
                String logContent;
                try {
                    logContent = FileUtil.loadFile((File)logFile);
                }
                catch (Exception e) {
                    logContent = "Unable to retrieve log: " + e.getMessage();
                }
                LOG.debug("Couldn't run process with PTY", new Object[]{t, logContent});
            } else {
                LOG.debug("Couldn't run process with PTY", t);
            }
            Process process2 = super.startProcess(commands);
            if (process2 == null) {
                PtyCommandLine.$$$reportNull$$$0(4);
            }
            return process2;
        }
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(3);
        }
        return process;
    }

    private static File getPtyLogFile() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands) throws IOException {
        Process process;
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(5);
        }
        ArrayList<Pair<String, String>> backup = new ArrayList<Pair<String, String>>();
        try {
            if (SystemInfo.isUnix && (this.myInitialColumns > 0 || this.myInitialRows > 0)) {
                PtyCommandLine.setSystemProperty(UNIX_PTY_INIT, Boolean.toString(true), backup);
                if (this.myInitialColumns > 0) {
                    PtyCommandLine.setSystemProperty(UNIX_PTY_COLUMNS, Integer.toString(this.myInitialColumns), backup);
                }
                if (this.myInitialRows > 0) {
                    PtyCommandLine.setSystemProperty(UNIX_PTY_ROWS, Integer.toString(this.myInitialRows), backup);
                }
            } else if (SystemInfo.isWindows) {
                if (this.myInitialColumns > 0) {
                    PtyCommandLine.setSystemProperty(WIN_PTY_COLUMNS, Integer.toString(this.myInitialColumns), backup);
                }
                if (this.myInitialRows > 0) {
                    PtyCommandLine.setSystemProperty(WIN_PTY_ROWS, Integer.toString(this.myInitialRows), backup);
                }
            }
            process = this.doStartProcessWithPty(commands);
        }
        catch (Throwable throwable) {
            for (Pair pair : backup) {
                PtyCommandLine.setSystemProperty((String)pair.first, (String)pair.second, null);
            }
            throw throwable;
        }
        for (Pair pair : backup) {
            PtyCommandLine.setSystemProperty((String)pair.first, (String)pair.second, null);
        }
        Process process2 = process;
        if (process2 == null) {
            PtyCommandLine.$$$reportNull$$$0(6);
        }
        return process2;
    }

    private static void setSystemProperty(@NotNull String propertyName, @Nullable String newPropertyValue, @Nullable List<Pair<String, String>> backup) {
        if (propertyName == null) {
            PtyCommandLine.$$$reportNull$$$0(7);
        }
        if (backup != null) {
            String oldValue = System.getProperty(propertyName);
            backup.add((Pair<String, String>)Pair.create((Object)propertyName, (Object)oldValue));
        }
        if (newPropertyValue != null) {
            System.setProperty(propertyName, newPropertyValue);
        } else {
            System.clearProperty(propertyName);
        }
    }

    @NotNull
    private Process doStartProcessWithPty(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(8);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        String[] command = ArrayUtil.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        boolean cygwin = this.myUseCygwinLaunch && SystemInfo.isWindows;
        PtyProcessBuilder builder = new PtyProcessBuilder(command).setEnvironment(env).setDirectory(directory).setConsole(this.myConsoleMode).setCygwin(cygwin).setLogFile(PtyCommandLine.getPtyLogFile()).setRedirectErrorStream(this.isRedirectErrorStream());
        PtyProcess ptyProcess = builder.start();
        if (ptyProcess == null) {
            PtyCommandLine.$$$reportNull$$$0(9);
        }
        return ptyProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessWithPty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartProcessWithPty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startProcessWithPty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSystemProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doStartProcessWithPty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

