/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class JSBooleanLiteralTypeImpl
extends JSBooleanType
implements JSPrimitiveLiteralType<Boolean> {
    private final boolean myLiteral;
    private final boolean myAllowWidening;

    public JSBooleanLiteralTypeImpl(boolean literal, boolean allowWidening, @NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
    }

    protected JSBooleanLiteralTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (serialized == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(source, serialized);
        this.myLiteral = JSTypeSerializer.readBoolean(serialized);
        this.myAllowWidening = JSTypeSerializer.readBoolean(serialized);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myLiteral, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public Boolean getLiteral() {
        Boolean bl = this.myLiteral;
        if (bl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return bl;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Boolean" == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(5);
            }
            return "Boolean";
        }
        String stringVal = Boolean.toString(this.myLiteral).toLowerCase(Locale.getDefault());
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string = this.isTypeScript() && (!this.allowWidening() || format != JSType.TypeTextFormat.CODE) ? stringVal : "boolean";
            if (string == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = "Boolean(" + stringVal + ")";
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        if (elementType instanceof JSBooleanLiteralTypeImpl && this.getSource().isStrict() && !this.myAllowWidening) {
            return this.myLiteral == ((JSBooleanLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myAllowWidening && elementType instanceof JSBooleanType) {
            return this.isJavaScript();
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return this.myLiteral == ((JSBooleanLiteralTypeImpl)type).myLiteral && super.isEquivalentToWithSameClass(type, processingContext, allowResolve);
    }

    @Override
    @NotNull
    protected JSBooleanLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl((boolean)this.getLiteral(), this.myAllowWidening, source);
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        if ("boolean" == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return "boolean";
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    public boolean isWidened() {
        return false;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = this;
            if (jSBooleanLiteralTypeImpl == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(14);
            }
            return jSBooleanLiteralTypeImpl;
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource());
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(15);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.myLiteral ? "true" : "false";
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

