/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExpectedTypeEvaluator
extends ExpectedTypeEvaluator {
    public TypeScriptExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        super(parent, expectedTypeKind);
    }

    @Override
    protected TypeScriptExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        return new TypeScriptExpectedTypeEvaluator(parent, expectedTypeKind);
    }

    @Override
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type, @Nullable JSExpression operand) {
        return type == null ? JSResolveUtil.getExpressionJSType(operand) : type;
    }

    public void visitTypeScriptLiteralType(TypeScriptLiteralType node) {
        JSExpression expression = node.getExpression();
        if (expression != this.myParent) {
            return;
        }
        TypeScriptType type = TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections((TypeScriptType)node, this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED);
        PsiElement typeParent = type.getParent();
        if (typeParent instanceof TypeScriptTypeArgumentList) {
            this.computeForTypeArgumentsListItem(type, (TypeScriptTypeArgumentList)typeParent);
        }
        if (typeParent instanceof TypeScriptIndexedAccessType) {
            this.computeForIndexerArgument((TypeScriptIndexedAccessType)typeParent);
        }
    }

    private void computeForIndexerArgument(@NotNull TypeScriptIndexedAccessType parent) {
        TypeScriptType element;
        if (parent == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(0);
        }
        if ((element = parent.getOwnerTypeElement()) == null) {
            return;
        }
        JSType indexed = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)element);
        this.myResult = new TypeScriptTypeOperatorJSTypeImpl(indexed, JSTypeSourceFactory.createTypeSource((PsiElement)parent, true));
    }

    private void computeForTypeArgumentsListItem(@NotNull TypeScriptType type, @NotNull TypeScriptTypeArgumentList typeParent) {
        Object[] typeArguments;
        int index;
        if (type == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (typeParent == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(2);
        }
        if ((index = ArrayUtil.indexOf((Object[])(typeArguments = typeParent.getTypeArguments()), (Object)type)) < 0) {
            return;
        }
        PsiElement singleTypeUsage = typeParent.getParent();
        if (!(singleTypeUsage instanceof TypeScriptSingleType)) {
            return;
        }
        JSReferenceExpression referenceExpression = ((TypeScriptSingleType)singleTypeUsage).getReferenceExpression();
        if (referenceExpression == null) {
            return;
        }
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return;
        }
        TypeScriptTypeParameterList typeParams = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
        if (typeParams == null) {
            return;
        }
        TypeScriptTypeParameter[] typeParameters = typeParams.getTypeParameters();
        if (typeParameters.length <= index) {
            return;
        }
        TypeScriptTypeParameter param = typeParameters[index];
        if (param == null) {
            return;
        }
        TypeScriptType constraint = param.getTypeConstraint();
        if (constraint == null) {
            return;
        }
        JSType cType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
        if (!JSTypeUtils.hasForeignGenericParameter(cType)) {
            this.myResult = cType;
            return;
        }
        JSTypeSubstitutor subst = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameters, Arrays.stream(typeArguments).map(a -> TypeScriptTypeParser.buildTypeFromTypeScript(a)).collect(Collectors.toList()));
        this.myResult = cType = JSTypeUtils.applyGenericArguments(cType, subst);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/TypeScriptExpectedTypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeForIndexerArgument";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeForTypeArgumentsListItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

