/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.LinterExecutionException;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EsLintExternalRunner<TResult> {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private final EslintLanguageServiceClient myLanguageService;

    public EsLintExternalRunner(boolean isOnTheFly, @NotNull EslintLanguageServiceClient service) {
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(0);
        }
        this.myIsOnTheFly = isOnTheFly;
        this.myLanguageService = service;
    }

    @NotNull
    public static JSLinterAnnotationResult<EslintState> highlight(final @NotNull JSLinterInput<EslintState> input, final @NotNull EslintLanguageServiceClient service, boolean isOnTheFly) {
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(1);
        }
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(2);
        }
        final Ref bestGuessConfig = new Ref(null);
        EsLintExternalRunner<List<EslintError>> runner = new EsLintExternalRunner<List<EslintError>>(isOnTheFly, service){

            @Override
            @Nullable
            protected Future<Pair<String, List<EslintError>>> performServiceRequest(@NotNull EslintSessionData sessionData, @Nullable VirtualFile explicitConfigFile) {
                if (sessionData == null) {
                    1.$$$reportNull$$$0(0);
                }
                bestGuessConfig.set(ObjectUtils.coalesce((Object)explicitConfigFile, (Object)ContainerUtil.getFirstItem(sessionData.findConfigs())));
                return service.highlight(sessionData.getFileToLint(), explicitConfigFile, sessionData.getFileToLintContent(), ((EslintState)input.getState()).getExtraOptions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner$1", "performServiceRequest"));
            }
        };
        try {
            List execute = (List)ObjectUtils.coalesce(runner.execute(input), Collections.emptyList());
            jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(input, execute, (VirtualFile)bestGuessConfig.get());
        }
        catch (LinterExecutionException e) {
            JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult2 = JSLinterAnnotationResult.create(input, e.getAnnotation(), (VirtualFile)bestGuessConfig.get());
            if (jSLinterAnnotationResult2 == null) {
                EsLintExternalRunner.$$$reportNull$$$0(4);
            }
            return jSLinterAnnotationResult2;
        }
        if (jSLinterAnnotationResult == null) {
            EsLintExternalRunner.$$$reportNull$$$0(3);
        }
        return jSLinterAnnotationResult;
    }

    @Nullable
    public static String fixFile(final @NotNull JSLinterInput<EslintState> input, final @NotNull EslintLanguageServiceClient service) throws LinterExecutionException {
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(5);
        }
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(6);
        }
        EsLintExternalRunner<String> runner = new EsLintExternalRunner<String>(false, service){

            @Override
            @Nullable
            protected Future<Pair<String, String>> performServiceRequest(@NotNull EslintSessionData sessionData, @Nullable VirtualFile explicitConfigFile) {
                if (sessionData == null) {
                    2.$$$reportNull$$$0(0);
                }
                return service.fixFile(sessionData.getFileToLint(), explicitConfigFile, sessionData.getFileToLintContent(), ((EslintState)input.getState()).getExtraOptions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner$2", "performServiceRequest"));
            }
        };
        return (String)runner.execute(input);
    }

    @Nullable
    protected abstract Future<Pair<String, TResult>> performServiceRequest(@NotNull EslintSessionData var1, @Nullable VirtualFile var2);

    @Nullable
    private static EslintSessionData createSessionData(@NotNull Project project, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile) {
        VirtualFile workingDir;
        if (project == null) {
            EsLintExternalRunner.$$$reportNull$$$0(7);
        }
        if (fileToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(8);
        }
        if (fileContentToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(9);
        }
        if ((workingDir = EsLintExternalRunner.guessWorkingDirectory(project, fileToLint)) == null) {
            LOG.debug("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.debug(String.format("No parent directory for file %s", fileToLint.getPath()));
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        VirtualFile eslintIgnoreFile;
        if (project == null) {
            EsLintExternalRunner.$$$reportNull$$$0(10);
        }
        if (fileToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(11);
        }
        VirtualFile eslintIgnoreFileDir = (eslintIgnoreFile = EslintUtil.lookupIgnoreFile(fileToLint, project)) != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private TResult eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> possibleConfigs) throws LinterExecutionException {
        String error;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(12);
        }
        if (sessionData == null) {
            EsLintExternalRunner.$$$reportNull$$$0(13);
        }
        if (possibleConfigs == null) {
            EsLintExternalRunner.$$$reportNull$$$0(14);
        }
        if (!EslintUtil.lintThisFileType(input.getProject(), input.getPsiFile(), possibleConfigs, input.getState())) {
            return null;
        }
        VirtualFile explicitConfig = sessionData.getSpecifiedConfigFile();
        Future<Pair<String, TResult>> future = this.performServiceRequest(sessionData, explicitConfig);
        Pair<String, TResult> result2 = null;
        try {
            result2 = JSLanguageServiceUtil.awaitLanguageService(future, this.myLanguageService);
            error = result2 == null ? "Can not get result from language service" : (String)result2.getFirst();
        }
        catch (ExecutionException e) {
            error = e.getMessage();
        }
        Pair<String, TResult> pair = result2;
        if (error != null) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(error);
            IntentionAction detailsAction = pair == null ? null : JSLinterUtil.createDetailsAction(input.getProject(), sessionData.getFileToLint(), null, output, JavaScriptLanguageIcons.FileTypes.Eslint);
            throw new LinterExecutionException(EsLintExternalRunner.createFileLevelAnnotation(error, detailsAction));
        }
        return (TResult)(pair != null ? pair.getSecond() : null);
    }

    private static JSLinterFileLevelAnnotation createFileLevelAnnotation(String error, @Nullable IntentionAction detailsAction) {
        String[] strings;
        JSLinterFileLevelAnnotation annotation = detailsAction == null ? new JSLinterFileLevelAnnotation(error) : new JSLinterFileLevelAnnotation(error, detailsAction);
        for (String string : strings = StringUtil.filterEmptyStrings((String[])StringUtil.splitByLines((String)error))) {
            if (FileUtil.isAbsolute((String)(string = string.trim())) || string.endsWith(":") && FileUtil.isAbsolute((String)string.substring(0, string.length() - 1)) || string.startsWith("Oops! Something went wrong! :(")) continue;
            annotation.setShortMessage(string);
            break;
        }
        return annotation.withIcon(JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    @Nullable
    public TResult execute(@NotNull JSLinterInput<EslintState> input) throws LinterExecutionException {
        VirtualFile specifiedConfigFile;
        EslintState state;
        VirtualFile fileToLint;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(15);
        }
        if (!(fileToLint = input.getVirtualFile()).isValid() || fileToLint.getParent() == null) {
            return null;
        }
        Project project = input.getProject();
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(project, "eslint", state = input.getState());
        if (error != null) {
            throw new LinterExecutionException(error);
        }
        SemVer packageVersion = new NodePackage(state.getEslintPackagePath()).getVersion();
        if (packageVersion != null && packageVersion.getMajor() < 1) {
            String message = String.format("This ESLint version (%s) is not supported. Please upgrade ESLint.", packageVersion.getRawVersion());
            throw new LinterExecutionException(new JSLinterFileLevelAnnotation(message));
        }
        try {
            if (!StringUtil.isEmptyOrSpaces((String)state.getAdditionalRulesDirPath())) {
                JSLinterUtil.checkPath(state.getAdditionalRulesDirPath(), true, "Additional rules directory");
            }
            specifiedConfigFile = state.isCustomConfigFileUsed() ? JSLinterUtil.checkPath(state.getCustomConfigFilePath(), false, "ESLint configuration file") : null;
        }
        catch (ExecutionException e) {
            throw new LinterExecutionException(new JSLinterFileLevelAnnotation(e.getMessage()));
        }
        EslintSessionData sessionData = (EslintSessionData)ReadAction.compute(() -> {
            if (input == null) {
                EsLintExternalRunner.$$$reportNull$$$0(16);
            }
            if (project.isDisposed()) {
                return null;
            }
            if (this.myIsOnTheFly) {
                EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
            }
            return EsLintExternalRunner.createSessionData(project, fileToLint, input.getFileContent(), specifiedConfigFile);
        });
        if (sessionData == null) {
            return null;
        }
        SmartList possibleConfigs = new SmartList();
        boolean runGranted = (Boolean)ReadAction.compute(() -> this.lambda$execute$1(project, (List)possibleConfigs, sessionData));
        if (runGranted) {
            return this.eslint(input, sessionData, (List<VirtualFile>)possibleConfigs);
        }
        LOG.debug("ESLint postponed because of unsaved configs");
        return null;
    }

    private /* synthetic */ Boolean lambda$execute$1(Project project, List possibleConfigs, EslintSessionData sessionData) throws RuntimeException {
        if (project.isDisposed()) {
            return false;
        }
        possibleConfigs.addAll(sessionData.findConfigs());
        return !this.myIsOnTheFly || EslintUnsavedConfigManager.getInstance(project).requestSaveIfNeeded(possibleConfigs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentToLint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "highlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSessionData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "eslint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

