/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.references;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JSXResolveUtil {
    @NotNull
    public static Collection<? extends PsiElement> resolveTopLevelName(@NotNull PsiElement context, @NotNull String name) {
        PsiElement local;
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(1);
        }
        if ((local = JSStubBasedPsiTreeUtil.resolveLocally(name, context)) != null || !DialectDetector.isTypeScript(context)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)local);
            if (list == null) {
                JSXResolveUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(name, context);
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveNestedName(@NotNull PsiElement context, @NotNull String name, @NotNull Collection<? extends PsiElement> scopes, @NotNull JSXNamespaceReference parent) {
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(5);
        }
        if (scopes == null) {
            JSXResolveUtil.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            JSXResolveUtil.$$$reportNull$$$0(7);
        }
        if (parent.isThisQualifier()) {
            Collection collection = scopes.stream().flatMap(scope -> {
                if (name == null) {
                    JSXResolveUtil.$$$reportNull$$$0(19);
                }
                return Stream.of(JSQualifiedNameResolver.processDeclarationsForScope(name, scope, false));
            }).filter(el -> el.isValidResult()).map(el -> el.getElement()).filter(Objects::nonNull).collect(Collectors.toList());
            if (collection == null) {
                JSXResolveUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        JSQualifiedNameResolver resolver = JSXResolveUtil.createResolver(context);
        Collection<PsiElement> collection = resolver.getLocalElements(name, scopes, true);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> expandReferenceElements(@NotNull PsiElement context, @NotNull JSXNamespaceReference reference) {
        Collection<PsiElement> elements;
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(10);
        }
        if (reference == null) {
            JSXResolveUtil.$$$reportNull$$$0(11);
        }
        if ((elements = JSResolveResult.resolveReference(reference)).isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSXResolveUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        Collection<PsiElement> collection = JSXResolveUtil.expandElements(context, elements);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    private static JSQualifiedNameResolver createResolver(@NotNull PsiElement context) {
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(14);
        }
        JSQualifiedNameResolver jSQualifiedNameResolver = DialectDetector.isTypeScript(context) ? new TypeScriptQualifiedNameResolver(context, true) : new ES6QualifiedNameResolver(context, true);
        if (jSQualifiedNameResolver == null) {
            JSXResolveUtil.$$$reportNull$$$0(15);
        }
        return jSQualifiedNameResolver;
    }

    @NotNull
    private static Collection<PsiElement> expandElements(@NotNull PsiElement context, @NotNull Collection<? extends PsiElement> elements) {
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(16);
        }
        if (elements == null) {
            JSXResolveUtil.$$$reportNull$$$0(17);
        }
        JSQualifiedNameResolver resolver = JSXResolveUtil.createResolver(context);
        Collection<PsiElement> collection = resolver.expandElements(elements);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(18);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/references/JSXResolveUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/references/JSXResolveUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNestedName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandReferenceElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolver";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTopLevelName";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveNestedName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandReferenceElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createResolver";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveNestedName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

