/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolsIgnoreFilesConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project myProject;
    private JPanel myIgnoreFilesPanel;
    private JPanel myBlackListToolbarPanel;
    private JBTable myBlackListTable;
    private QualityToolBlackList.BlackListTableModel myBlackListTableModel;

    public QualityToolsIgnoreFilesConfigurable(@Nullable QualityToolBlackList blackList, final @NotNull Project project) {
        if (project == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction("Add file(s) to the list", null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel != null) {
                    QualityToolsIgnoreFilesConfigurable.this.doChooseFiles(project, (Consumer<List<VirtualFile>>)QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel::addAll);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$1", "actionPerformed"));
            }
        });
        group.add(new AnAction("Remove file(s) from the list", null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                QualityToolsIgnoreFilesConfigurable.this.removeSelectedFilesFromBlackList();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(QualityToolsIgnoreFilesConfigurable.this.myBlackListTable.getSelectedRows().length > 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add(new AnAction("Clean the list", null, AllIcons.Actions.Delete){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel != null) {
                    QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$3", "actionPerformed"));
            }
        });
        this.myBlackListToolbarPanel.add((Component)ActionManager.getInstance().createActionToolbar("PhpQualityToolProjectConfigurable", (ActionGroup)group, true).getComponent(), "Center");
        if (blackList != null) {
            this.myBlackListTableModel = blackList.createTableModel();
            this.myBlackListTable.setModel((TableModel)this.myBlackListTableModel);
        } else {
            this.myBlackListTable.setVisible(false);
        }
        this.myIgnoreFilesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Ignored files"));
    }

    private void removeSelectedFilesFromBlackList() {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.removeAll(this.myBlackListTable.getSelectedRows());
        }
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<List<VirtualFile>> consumer) {
        if (project == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(2);
        }
        FileChooser.chooseFiles((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, true), (Project)project, (Component)this.myIgnoreFilesPanel.getParent(), (VirtualFile)project.getBaseDir(), consumer);
    }

    public void apply() throws ConfigurationException {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.commit();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Nullable
    public JComponent createComponent() {
        return this.myIgnoreFilesPanel;
    }

    public boolean isModified() {
        return this.myBlackListTableModel != null && this.myBlackListTableModel.isModified();
    }

    public void reset() {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.reset();
        }
    }

    public void selectFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(3);
        }
        int index = 0;
        for (VirtualFile file : this.myBlackListTableModel.getEditableFileList()) {
            if (files.contains(file)) {
                this.myBlackListTable.addRowSelectionInterval(index, index);
            }
            ++index;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return this.getQualityToolName() + " Ignored Files";
    }

    @NotNull
    protected abstract String getQualityToolName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIgnoreFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBlackListToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBlackListTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
    }
}

