/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceFieldIntroducer;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldSettings;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldInplaceIntroduceFacade
implements PhpInplaceIntroduceFacade<PhpIntroduceFieldSettings> {
    private final PhpIntroduceContext myContext;
    private final LinkedHashSet<String> mySuggestedNames;

    public PhpFieldInplaceIntroduceFacade(PhpIntroduceContext context) {
        this.myContext = context;
        Set occupiedNames = ContainerUtil.map2Set(FieldImpl.collectFieldDeclarations((PhpPsiElement)context.getScope()), PhpNamedElement::getName);
        this.mySuggestedNames = ContainerUtil.newLinkedHashSet((Object[])new PhpIntroduceFieldNameSuggestionProvider(context, occupiedNames).getSuggestedNames());
    }

    @Override
    @NotNull
    public PhpIntroduceFieldSettings getSettings(final boolean replaceAllOccurrences) {
        final PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myContext.getFile(), PhpCodeStyleSettings.class);
        final String suggestedName = (String)ContainerUtil.getFirstItem(this.mySuggestedNames);
        final boolean isStatic = PhpIntroduceFieldHandler.isStaticContext(this.myContext.getContext());
        PhpIntroduceFieldSettings phpIntroduceFieldSettings = new PhpIntroduceFieldSettings(){

            @Override
            public PhpModifier.Access getAccess() {
                return settings.FIELDS_DEFAULT_VISIBILITY;
            }

            @Override
            public PhpIntroduceFieldSettings.InitPlace getInitPlace() {
                PhpIntroduceFieldSettings.InitPlace lastSelectedInitPlace = PhpInplaceFieldIntroducer.getLastSelectedInitPlace(PhpFieldInplaceIntroduceFacade.this.myContext.getProject());
                if (this.isSuitableInitPlace(lastSelectedInitPlace)) {
                    return lastSelectedInitPlace;
                }
                return PhpIntroduceFieldSettings.InitPlace.CURRENT_METHOD;
            }

            private boolean isSuitableInitPlace(PhpIntroduceFieldSettings.InitPlace lastSelectedInitPlace) {
                return lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION && PhpInplaceFieldIntroducer.allowInitInFieldDeclaration(PhpFieldInplaceIntroduceFacade.this.myContext) || lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.CONSTRUCTOR && PhpInplaceFieldIntroducer.allowInitInConstructor(PhpFieldInplaceIntroduceFacade.this.myContext) || lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.SET_UP && PhpInplaceFieldIntroducer.allowInitInSetUp(PhpFieldInplaceIntroduceFacade.this.myContext);
            }

            @Override
            public boolean isStatic() {
                return isStatic;
            }

            @Override
            public boolean isEmbedVariable() {
                return false;
            }

            @Override
            public String getName() {
                return suggestedName != null ? suggestedName : "t";
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAllOccurrences;
            }
        };
        if (phpIntroduceFieldSettings == null) {
            PhpFieldInplaceIntroduceFacade.$$$reportNull$$$0(0);
        }
        return phpIntroduceFieldSettings;
    }

    @Override
    public void performInplaceIntroduce(@NotNull PsiElement introducedElement, PhpIntroduceFieldSettings settings) {
        Field field;
        if (introducedElement == null) {
            PhpFieldInplaceIntroduceFacade.$$$reportNull$$$0(1);
        }
        if ((field = PhpFieldInplaceIntroduceFacade.resolveFieldReferenceAtOffset(this.myContext, settings, introducedElement)) != null) {
            new PhpInplaceFieldIntroducer(this.myContext, settings, (PsiNamedElement)field, introducedElement).performInplaceRefactoring(this.mySuggestedNames);
        }
    }

    @Nullable
    public static Field resolveFieldReferenceAtOffset(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceFieldSettings settings, @Nullable PsiElement introducedElement) {
        if (context == null) {
            PhpFieldInplaceIntroduceFacade.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            PhpFieldInplaceIntroduceFacade.$$$reportNull$$$0(3);
        }
        if (context.isToReplaceSourceElement() && settings.getInitPlace() == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION) {
            return (Field)ObjectUtils.tryCast((Object)introducedElement, Field.class);
        }
        PsiReference fieldReference = PhpRefactoringUtil.getReferenceAtCaret(context.getScope(), context.getEditor());
        if (fieldReference instanceof Variable && StringUtil.equals((CharSequence)((Variable)fieldReference).getName(), (CharSequence)"this")) {
            fieldReference = (PsiReference)ObjectUtils.tryCast((Object)((Variable)fieldReference).getParent(), PsiReference.class);
        }
        if (context.isToReplaceSourceElement()) {
            PsiElement parentStatement = settings.getInitPlace() == PhpIntroduceFieldSettings.InitPlace.CONSTRUCTOR || settings.getInitPlace() == PhpIntroduceFieldSettings.InitPlace.SET_UP ? introducedElement : PhpFieldInplaceIntroduceFacade.findElementAtOffset(context);
            AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getChildByCondition(parentStatement, (Condition<? super PsiElement>)((Condition)AssignmentExpression.class::isInstance));
            if (assignment != null) {
                fieldReference = (PsiReference)PhpPsiUtil.getParentByCondition((PsiElement)assignment.getVariable(), false, (Condition<? super PsiElement>)((Condition)FieldReference.class::isInstance));
            }
        }
        if (fieldReference != null) {
            return (Field)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAtOffset(PhpIntroduceContext context) {
        int offset = context.getEditor().getCaretModel().getOffset();
        PsiFile file = context.getFile();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            element = file.findElementAt(offset - 1);
        }
        while (PhpPsiUtil.isOfType(element, TokenType.WHITE_SPACE, PhpTokenTypes.opSEMICOLON)) {
            element = element.getPrevSibling();
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/inplace/PhpFieldInplaceIntroduceFacade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/inplace/PhpFieldInplaceIntroduceFacade";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveFieldReferenceAtOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

