/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Statement;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class IfStatement {
    private static final TokenSet WHERE_TO_STOP = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwELSEIF, PhpTokenTypes.kwELSE, PhpTokenTypes.kwENDIF});
    public static final TokenSet ENDIF = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwENDIF});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        if (!builder.compareAndEat(PhpTokenTypes.kwIF)) {
            statement.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.chLPAREN);
        IElementType result = Expression.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error("Expected: expression");
        }
        builder.match(PhpTokenTypes.chRPAREN);
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            IfStatement.parseNewStyleIf(builder);
            builder.match(PhpTokenTypes.kwENDIF);
            if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
                builder.match(PhpTokenTypes.opSEMICOLON);
            }
        } else {
            IfStatement.parseOldStyleIf(builder);
        }
        statement.done(PhpElementTypes.IF);
        return PhpElementTypes.IF;
    }

    private static void parseNewStyleIf(PhpPsiBuilder builder) {
        StatementList.parseAccurate(builder, WHERE_TO_STOP);
        while (builder.compare(PhpTokenTypes.kwELSEIF)) {
            PsiBuilder.Marker elseifClause = builder.mark();
            builder.advanceLexer();
            builder.match(PhpTokenTypes.chLPAREN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error("Expected: expression");
            }
            builder.match(PhpTokenTypes.chRPAREN);
            builder.match(PhpTokenTypes.opCOLON);
            StatementList.parseAccurate(builder, WHERE_TO_STOP);
            elseifClause.done(PhpElementTypes.ELSE_IF);
        }
        if (builder.compare(PhpTokenTypes.kwELSE)) {
            PsiBuilder.Marker elseClause = builder.mark();
            builder.advanceLexer();
            builder.match(PhpTokenTypes.opCOLON);
            StatementList.parseAccurate(builder, ENDIF);
            elseClause.done(PhpElementTypes.ELSE);
        }
    }

    private static void parseOldStyleIf(PhpPsiBuilder builder) {
        Statement.parse(builder);
        while (builder.compare(PhpTokenTypes.kwELSEIF)) {
            PsiBuilder.Marker elseifClause = builder.mark();
            builder.advanceLexer();
            builder.match(PhpTokenTypes.chLPAREN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error("Expected: expression");
            }
            builder.match(PhpTokenTypes.chRPAREN);
            Statement.parse(builder);
            elseifClause.done(PhpElementTypes.ELSE_IF);
        }
        if (builder.compare(PhpTokenTypes.kwELSE)) {
            PsiBuilder.Marker elseClause = builder.mark();
            builder.advanceLexer();
            Statement.parse(builder);
            elseClause.done(PhpElementTypes.ELSE);
        }
    }
}

