/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PhpSimplifyFQNIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = PhpBundle.message("intention.simplify.fqn", new Object[0]);

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(2);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpReference reference = PhpPsiUtil.getClassReferenceAt(element);
        if (!(reference instanceof ClassReference || reference instanceof PhpDocType || reference instanceof ConstantReference || reference instanceof FunctionReference)) {
            return false;
        }
        PhpDocTag docTag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        if (docTag != null && StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass")) {
            return false;
        }
        if (PhpCodeInsightUtil.isFullyQualified(reference)) {
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
            if (scopeForUseOperator == null) {
                return false;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(reference);
            if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                return false;
            }
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn);
            if (!PhpLangUtil.isFqn(qualifiedName)) {
                this.setText(NAME);
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpReference reference;
        if (project == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(4);
        }
        if ((reference = PhpPsiUtil.getClassReferenceAt(element)) == null) {
            return;
        }
        String fqn = PhpCodeInsightUtil.getImmediateFQN(reference);
        if (fqn == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (scopeForUseOperator == null) {
            return;
        }
        if (reference instanceof ConstantReference) {
            this.replaceConstantReference(project, scopeForUseOperator, fqn);
        } else if (reference instanceof FunctionReference) {
            this.replaceFunctionReference(project, scopeForUseOperator, fqn);
        } else {
            this.replaceClassReference(project, scopeForUseOperator, fqn);
        }
    }

    private void replaceConstantReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
        if (project == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(5);
        }
        if (scopeForUseOperator == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(6);
        }
        if (originalFqn == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(7);
        }
        final HashSet references = new HashSet();
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

            public void visitPhpConstantReference(ConstantReference reference) {
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)reference))) {
                    references.add(reference);
                }
            }
        });
        String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
        ConstantReference newConstantReference = PhpPsiElementFactory.createConstantReference(project, qualifiedName);
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (PhpReference reference : references) {
                reference.replace((PsiElement)newConstantReference);
            }
        }), this.getText(), null);
    }

    private void replaceFunctionReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
        if (project == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(8);
        }
        if (scopeForUseOperator == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(9);
        }
        if (originalFqn == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(10);
        }
        final HashSet references = new HashSet();
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)reference))) {
                    references.add(reference);
                }
            }
        });
        String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
        FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, qualifiedName + "()");
        PhpNamespaceReference newNamespaceReference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
        PsiElement newIdentifier = PhpPsiUtil.getChildOfType((PsiElement)functionReference, PhpTokenTypes.IDENTIFIER);
        assert (newIdentifier != null) : "Failed to find identifier in '" + functionReference.getText() + "'";
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (FunctionReference reference : references) {
                PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                Object namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
                if (namespaceReference != null) {
                    if (newNamespaceReference == null) {
                        namespaceReference.getParent().deleteChildRange(namespaceReference, namespaceReference);
                    } else {
                        namespaceReference.replace((PsiElement)newNamespaceReference);
                    }
                }
                assert (identifier != null) : "Failed to find identifier in '" + reference.getText() + "'";
                identifier.replace(newIdentifier);
            }
        }), this.getText(), null);
    }

    private void replaceClassReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
        if (project == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(11);
        }
        if (scopeForUseOperator == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(12);
        }
        if (originalFqn == null) {
            PhpSimplifyFQNIntention.$$$reportNull$$$0(13);
        }
        final HashSet references = new HashSet();
        final HashSet phpDocTypes = new HashSet();
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

            public void visitPhpDocType(PhpDocType phpDocType) {
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)phpDocType))) {
                    phpDocTypes.add(phpDocType);
                }
            }

            public void visitPhpClassReference(ClassReference classReference) {
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)classReference))) {
                    references.add(classReference);
                }
            }
        });
        String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
        ClassReference newClassReference = PhpPsiElementFactory.createClassReference(project, qualifiedName);
        PhpDocType newPhpDocType = PhpPsiElementFactory.createPhpDocType(project, qualifiedName);
        PhpDocType newPluralPhpDocType = PhpPsiElementFactory.createPhpDocType(project, qualifiedName + "[]");
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (ClassReference reference : references) {
                reference.replace((PsiElement)newClassReference);
            }
            for (PhpDocType phpDocType : phpDocTypes) {
                if (PhpType.isPluralType((String)phpDocType.getText())) {
                    phpDocType.replace((PsiElement)newPluralPhpDocType);
                    continue;
                }
                phpDocType.replace((PsiElement)newPhpDocType);
            }
        }), this.getText(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpSimplifyFQNIntention";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpSimplifyFQNIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceConstantReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceFunctionReference";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceClassReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReferenceInScopeCollector
    extends PhpRecursiveElementVisitor {
        private PhpReferenceInScopeCollector() {
        }

        public void visitPhpElement(PhpPsiElement element) {
            if (!(PhpCodeInsightUtil.isScopeForUseOperator(element) || element instanceof PhpUse && !((PhpUse)element).isTraitImport())) {
                super.visitPhpElement(element);
            }
        }
    }
}

