/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpStaticVsDynamicInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStaticAsDynamicMethodCallInspection
extends PhpStaticVsDynamicInspectionBase {
    private static final LocalQuickFix MAKE_CALL_STATIC_FIX = new MakeCallStaticQuickFix();
    public static final String MAKE_CALL_STATIC_FIX_NAME = MAKE_CALL_STATIC_FIX.getName();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStaticAsDynamicMethodCallInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference methodReference) {
                Method method;
                PsiElement resolvedElement;
                PsiReference reference;
                if (PhpPsiUtil.isOfType(methodReference.getParent(), PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                String methodName = methodReference.getName();
                if (methodName == null) {
                    return;
                }
                if (this.isDynamic(methodReference) && (reference = methodReference.getReference()) != null && (resolvedElement = reference.resolve()) instanceof Method && (method = (Method)resolvedElement).isStatic()) {
                    Project project = methodReference.getProject();
                    PhpType type = new PhpType().add((PsiElement)method.getContainingClass());
                    boolean hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, PhpIndex.getInstance((Project)project), "__call");
                    if (hasMagic) {
                        if (!PhpStaticAsDynamicMethodCallInspection.this.isShowForMagic()) {
                            return;
                        }
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.static.method.called.as.dynamic.problem.magic", new Object[0]), PhpStaticAsDynamicMethodCallInspection.this.getMagicHighlightType(), new LocalQuickFix[]{this.getQuickFix(methodReference)});
                    } else {
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.static.method.called.as.dynamic.problem", new Object[0]), new LocalQuickFix[]{this.getQuickFix(methodReference)});
                    }
                }
            }

            @Nullable
            private LocalQuickFix getQuickFix(@NotNull MethodReference methodReference) {
                PhpLanguageLevel languageLevel;
                if (methodReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((languageLevel = PhpProjectConfigurationFacade.getInstance(methodReference.getProject()).getLanguageLevel()).hasFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX) || methodReference.getFirstChild() instanceof Variable) {
                    return MAKE_CALL_STATIC_FIX;
                }
                return null;
            }

            private boolean isDynamic(@NotNull MethodReference methodReference) {
                if (methodReference == null) {
                    1.$$$reportNull$$$0(1);
                }
                return PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.ARROW) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "methodReference";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDynamic";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpStaticAsDynamicMethodCallInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MakeCallStaticQuickFix
    extends PhpQuickFixBase {
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.make.call.static.name", new Object[0]);
            if (string == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(2);
            }
            MemberReference methodReference = (MemberReference)PhpPsiUtil.getParentByCondition(descriptor.getPsiElement(), false, (Condition<? super PsiElement>)MemberReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            PhpExpression classReference = methodReference.getClassReference();
            assert (classReference != null);
            PsiElement arrow = PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.ARROW);
            if (arrow == null) {
                MakeCallStaticQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.can.not.find.dynamic.method.reference", new Object[0]), (PsiElement)methodReference);
                return;
            }
            arrow.replace(PhpPsiElementFactory.createScopeResolution(project));
            if ("$this".equals(classReference.getText())) {
                classReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, "static"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$MakeCallStaticQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$MakeCallStaticQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

