/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpFullyQualifiedNameUsageInspection
extends PhpInspection {
    private static final String PROBLEM = PhpBundle.message("inspection.fully.qualified.name.usage", new Object[0]);
    public boolean ENABLE_IN_FILE_SCOPE = false;
    public boolean IGNORE_GLOBAL_NAMESPACE = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference classReference) {
                String fqn;
                if (PhpCodeInsightUtil.hasQualifier((PhpReference)classReference) && PhpCodeInsightUtil.isFullyQualified((PhpReference)classReference) && PhpCodeInsightUtil.isImportSupported((PhpReference)classReference) && (fqn = classReference.getFQN()) != null && PhpLangUtil.isFqn(fqn)) {
                    String qualifiedName;
                    if (PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE && PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(fqn))) {
                        return;
                    }
                    PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
                    if ((scopeForUseOperator instanceof PhpNamespace || PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE && scopeForUseOperator instanceof PhpFile) && PhpLangUtil.isFqn(qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn)) && !PhpCodeInsightUtil.hasNameConflicts(scopeForUseOperator, fqn, PhpCodeInsightUtil.ImportElementType.CLASS)) {
                        holder.registerProblem((PsiElement)classReference, PROBLEM, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myMainPanel;
        private JBCheckBox myEnableFileScopeCheckBox;
        private JBCheckBox myIgnoreGlobalNamespaceCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableFileScopeCheckBox.setSelected(PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableFileScopeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableFileScopeCheckBox.isSelected();
                }
            });
            this.myIgnoreGlobalNamespaceCheckBox.setSelected(PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE);
            this.myIgnoreGlobalNamespaceCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE = OptionsPanel.this.myIgnoreGlobalNamespaceCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myEnableFileScopeCheckBox = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.fully.qualified.name.usage.option.enable.file.scope"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIgnoreGlobalNamespaceCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.fully.qualified.name.usage.name.option.ignore.global.namespace"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

