/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.DefaultExecutor;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.DisposableFutureHandle;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.experimental.JobKt;
import kotlinx.coroutines.experimental.ResumeUndispatchedRunnable;
import kotlinx.coroutines.experimental.TimeSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J*\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lkotlinx/coroutines/experimental/ExecutorCoroutineDispatcherBase;", "Lkotlinx/coroutines/experimental/ExecutorCoroutineDispatcher;", "Lkotlinx/coroutines/experimental/Delay;", "()V", "close", "", "dispatch", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/experimental/Runnable;", "equals", "", "other", "", "hashCode", "", "invokeOnTimeout", "Lkotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Lkotlinx/coroutines/experimental/timeunit/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "toString", "", "kotlinx-coroutines-core"})
public abstract class ExecutorCoroutineDispatcherBase
extends ExecutorCoroutineDispatcher
implements Delay {
    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        try {
            this.getExecutor().execute(TimeSourceKt.getTimeSource().trackTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.execute$kotlinx_coroutines_core(block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
        try {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(new ResumeUndispatchedRunnable(this, continuation), time, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        if (timeout != null) {
            JobKt.cancelFutureOnCancellation(continuation, (Future)timeout);
        } else {
            DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(time, unit, continuation);
        }
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        try {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(block, time, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        return timeout != null ? (DisposableHandle)new DisposableFutureHandle((Future)timeout) : DefaultExecutor.INSTANCE.invokeOnTimeout(time, unit, block);
    }

    @Override
    public void close() {
        block1: {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ExecutorService)) {
                executor2 = null;
            }
            ExecutorService executorService = (ExecutorService)executor2;
            if (executorService == null) break block1;
            executorService.shutdown();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherBase && ((ExecutorCoroutineDispatcherBase)other).getExecutor() == this.getExecutor();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor());
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation) {
        return Delay.DefaultImpls.delay(this, time, unit, continuation);
    }
}

