/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.ant.execution;

import com.intellij.rt.ant.execution.IdeaAntLogger2;
import com.intellij.rt.ant.execution.PacketFactory;
import com.intellij.rt.ant.execution.PacketWriter;
import com.intellij.rt.ant.execution.SegmentedOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;

public class IdeaInputHandler
implements InputHandler {
    public void handleInput(InputRequest request) throws BuildException {
        String prompt = request.getPrompt();
        if (prompt == null) {
            throw new BuildException("Prompt is null");
        }
        SegmentedOutputStream err = IdeaAntLogger2.ourErr;
        if (err == null) {
            throw new BuildException("Selected InputHandler should be used by Intellij IDEA");
        }
        PacketWriter packet = PacketFactory.ourInstance.createPacket('I');
        packet.appendLimitedString(prompt);
        packet.appendLimitedString(request.getDefaultValue());
        if (request instanceof MultipleChoiceInputRequest) {
            Vector choices = ((MultipleChoiceInputRequest)request).getChoices();
            if (choices != null && choices.size() > 0) {
                int count = choices.size();
                packet.appendLong(count);
                for (int i = 0; i < count; ++i) {
                    packet.appendLimitedString((String)choices.elementAt(i));
                }
            } else {
                packet.appendLong(0L);
            }
        } else {
            packet.appendLong(0L);
        }
        packet.sendThrough(err);
        try {
            byte[] replayLength = this.readBytes(4);
            int length = replayLength[0] << 24 | replayLength[1] << 16 | replayLength[2] << 8 | replayLength[3];
            byte[] replay = this.readBytes(length);
            String input = new String(replay);
            request.setInput(input);
            if (!request.isInputValid()) {
                throw new BuildException("Invalid input: " + input);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private byte[] readBytes(int count) throws IOException {
        byte[] replayLength = new byte[count];
        int read = System.in.read(replayLength);
        if (read != count) {
            throw new IOException("End of input stream");
        }
        return replayLength;
    }
}

