/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class RevertMutations
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            RevertMutations.$$$reportNull$$$0(0);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        boolean hasChanges = support.hasPendingChanges();
        boolean visible = (!support.isSubmitImmediately() || hasChanges) && !grid.getDataHookup().isReadOnly();
        boolean enabled = visible && hasChanges && support.canRevert() && RevertMutations.hasChangeUnderSelection(grid);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            RevertMutations.$$$reportNull$$$0(1);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null || !grid.getDataSupport().hasRowMutator()) {
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        ModelIndexSet<DataConsumer.Column> columns = grid.getSelectionModel().getSelectedColumns();
        ModelIndexSet<DataConsumer.Row> rows = grid.getSelectionModel().getSelectedRows();
        if (columns.size() != 0 && rows.size() != 0) {
            support.revert(rows, columns);
        }
    }

    private static boolean hasChangeUnderSelection(@NotNull DataGrid grid) {
        if (grid == null) {
            RevertMutations.$$$reportNull$$$0(2);
        }
        SelectionModel model = grid.getSelectionModel();
        ModelIndexSet rows = model.getSelectedRows();
        ModelIndexSet columns = model.getSelectedColumns();
        GridDataSupport support = grid.getDataSupport();
        for (ModelIndex rowIdx : rows.asIterable()) {
            ModelIndexSet<DataConsumer.Row> rowIdxSet = ModelIndexSet.forRows(grid, rowIdx.asInteger());
            if (support.isDeletedRows(rowIdxSet) || grid.isInsertedRow(rowIdx)) {
                return true;
            }
            for (ModelIndex columnIdx : columns.asIterable()) {
                if (!support.isModified(rowIdx, columnIdx)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/RevertMutations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasChangeUnderSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

