/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers;

import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableFKeyColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> {
    private final DatabaseMetaDataWrapper.Table myTable;
    private int myNumber;

    public TableFKeyColumnIt(@Nullable ResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableFKeyColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableFKeyColumn createStorage() {
        DatabaseMetaDataWrapper.TableFKeyColumn tableFKeyColumn = new DatabaseMetaDataWrapper.TableFKeyColumn(new DatabaseMetaDataWrapper.TableFKey(this.myTable, new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), ""));
        if (tableFKeyColumn == null) {
            TableFKeyColumnIt.$$$reportNull$$$0(1);
        }
        return tableFKeyColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableFKeyColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableFKeyColumn res2 = (DatabaseMetaDataWrapper.TableFKeyColumn)this.getStorageToFill();
        try {
            String fkName;
            String targetName = this.myRs.getString("PKTABLE_NAME", 3);
            String sourceName = this.myRs.getString("FKTABLE_NAME", 7);
            if (StringUtil.isEmpty((String)targetName) || StringUtil.isEmpty((String)sourceName)) {
                return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
            }
            String srcSchema = StringUtil.notNullize((String)this.myRs.getString("FKTABLE_SCHEM", 6), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)srcSchema, (String)this.myTable.schema.schema) || !Comparing.equal((String)sourceName, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
            }
            res2.position = this.myRs.getShort("KEY_SEQ", 9);
            if (res2.position == 0 || res2.position == 1) {
                ++this.myNumber;
            }
            if (StringUtil.isEmpty((String)(fkName = this.myRs.getString("FK_NAME", 12)))) {
                fkName = "#FAKE_" + sourceName + "_" + this.myNumber;
                res2.fk.surrogateName = true;
            } else {
                res2.fk.surrogateName = false;
            }
            res2.fk.name = fkName;
            res2.fk.targetTable.schema.database = (String)ObjectUtils.chooseNotNull((Object)StringUtil.nullize((String)this.myRs.getString("PKTABLE_CAT", 1)), (Object)this.myTable.schema.database);
            res2.fk.targetTable.schema.schema = (String)ObjectUtils.chooseNotNull((Object)this.myRs.getString("PKTABLE_SCHEM", 2), (Object)this.myTable.schema.schema);
            res2.fk.targetTable.name = targetName;
            res2.fk.updateRule = this.myRs.getShort("UPDATE_RULE", 10);
            res2.fk.deleteRule = this.myRs.getShort("DELETE_RULE", 11);
            res2.fk.deferrability = this.myRs.getShort("DEFERRABILITY", 14);
            res2.name = this.myRs.getString("FKCOLUMN_NAME", 8);
            res2.targetName = this.myRs.getString("PKCOLUMN_NAME", 4);
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableFKeyColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.fk.table.schema.database, cur.fk.table.schema.schema, cur.fk.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableFKeyColumnIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableFKeyColumnIt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn, DatabaseMetaDataWrapper.TableFKeyColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableFKeyColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> it) {
            final String fkName = ((DatabaseMetaDataWrapper.TableFKeyColumn)it.current()).fk.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableFKeyColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableFKeyColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableFKeyColumn item) {
                    return Comparing.equal((String)fkName, (String)item.fk.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.TableFKey getItem(ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> it) {
            return ((DatabaseMetaDataWrapper.TableFKeyColumn)it.current()).fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableFKeyColumnIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableFKeyColumnIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

