/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.diagnostic.ThreadDumper;
import java.beans.Introspector;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class GCUtil {
    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ArrayList<SoftReference<byte[]>> list = new ArrayList<SoftReference<byte[]>>(100 + GCUtil.useReference(ref));
        System.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        try {
            int i = 0;
            while (q.poll() == null) {
                int bytes = Math.min((int)((double)freeMemory * 0.05), 0x3FFFFFFF);
                list.add(new SoftReference<byte[]>(new byte[bytes]));
                if (++i <= 1000) continue;
                System.out.println("GCUtil.tryGcSoftlyReachableObjects: giving up");
                break;
            }
            list.ensureCapacity(list.size() + GCUtil.useReference(ref));
            for (SoftReference softReference : list) {
                softReference.clear();
            }
        }
        catch (OutOfMemoryError e) {
            int size = list.size();
            list.clear();
            e.printStackTrace();
            System.err.println("Free memory before: " + freeMemory + "; .freeMemory() now: " + Runtime.getRuntime().freeMemory() + "; list.size(): " + size);
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw e;
        }
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }

    public static void clearBeanInfoCache() {
        Introspector.flushCaches();
    }
}

