/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtilRt {
    public static void rethrowUnchecked(@Nullable Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        if (t != null) {
            ExceptionUtilRt.rethrowUnchecked(t);
            throw (Exception)t;
        }
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtilRt.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtilRt.rethrow(t);
        }
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            ExceptionUtilRt.$$$reportNull$$$0(0);
        }
        if (stackFrameSkipPattern == null) {
            ExceptionUtilRt.$$$reportNull$$$0(1);
        }
        String prefix = "\tat ";
        String prefixProxy = "\tat $Proxy";
        String prefixRemoteUtil = "\tat com.intellij.execution.rmi.RemoteUtil";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            private boolean skipping;

            public void println(String x) {
                boolean curSkipping = this.skipping;
                if (x != null) {
                    if (!this.skipping && x.startsWith(skipPattern)) {
                        curSkipping = true;
                    } else if (this.skipping && !x.startsWith("\tat ")) {
                        curSkipping = false;
                    }
                    if (curSkipping && !this.skipping) {
                        super.println("\tin " + ExceptionUtilRt.stripPackage(x, skipPattern.length()));
                    }
                    this.skipping = curSkipping;
                    if (this.skipping) {
                        this.skipping = !x.startsWith("\tat com.intellij.execution.rmi.RemoteUtil");
                        return;
                    }
                    if (x.startsWith("\tat $Proxy")) {
                        return;
                    }
                    super.println(x);
                }
            }
        };
        aThrowable.printStackTrace(writer);
        String string = stringWriter.getBuffer().toString();
        if (string == null) {
            ExceptionUtilRt.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtilRt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtilRt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

