/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ErrorLabel
extends JLabel {
    private boolean myUnderline;
    private Color myForeground;
    private String myTooltip;

    public ErrorLabel() {
        this(null, null);
    }

    public ErrorLabel(String text) {
        this(text, null);
    }

    public ErrorLabel(String text, Icon icon) {
        super(text, icon, 2);
        this.setOpaque(false);
    }

    public void setErrorText(String text, Color color) {
        boolean newUnderline = text != null;
        this.myForeground = color;
        if (newUnderline) {
            this.updateLabelView(newUnderline, text);
        } else if (this.myUnderline) {
            this.updateLabelView(newUnderline, this.myTooltip);
        }
    }

    @Override
    public void setToolTipText(String text) {
        if (this.myUnderline) {
            this.myTooltip = text;
        } else {
            super.setToolTipText(text);
        }
    }

    private void updateLabelView(boolean newUnderline, String tooltip) {
        super.setToolTipText(tooltip);
        this.myUnderline = newUnderline;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String text = this.getText();
        if (text != null && this.myUnderline) {
            Border border;
            g.setColor(this.myForeground);
            int x = 0;
            Icon icon = this.getIcon();
            if (icon != null) {
                x = icon.getIconWidth() + this.getIconTextGap();
            }
            if (this.getHorizontalAlignment() == 0) {
                int w = g.getFontMetrics().stringWidth(text);
                x += this.getWidth() - x - w >> 1;
            }
            if ((border = this.getBorder()) != null) {
                Insets insets = border.getBorderInsets(this);
                if (insets.left != -1) {
                    x += insets.left;
                }
            }
            ErrorLabel.drawWave(this, g, x, text);
        }
    }

    public static void drawWave(Component c, Graphics g, int x, String text) {
        int line;
        int y = ErrorLabel.getTextBaseLine(c);
        int width = c.getFontMetrics(c.getFont()).stringWidth(text);
        int nLines = (width >> 1) + 1;
        int xCurr = x;
        int yBottom = (y += 2) + 1;
        int[] xx = new int[nLines + 1];
        int[] yy = new int[nLines + 1];
        for (line = 0; line < nLines; line += 2) {
            xx[line] = xCurr;
            yy[line] = yBottom;
            xx[line + 1] = xCurr + 2;
            yy[line + 1] = yBottom - 2;
            xCurr += 4;
        }
        g.drawPolyline(xx, yy, line);
    }

    private static int getTextBaseLine(Component c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return (c.getHeight() >> 1) + (fm.getHeight() >> 1) - fm.getDescent();
    }
}

