/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LanguageImportStatements
extends LanguageExtension<ImportOptimizer> {
    public static final LanguageImportStatements INSTANCE = new LanguageImportStatements();

    private LanguageImportStatements() {
        super("com.intellij.lang.importOptimizer");
    }

    @NotNull
    public Set<ImportOptimizer> forFile(@NotNull PsiFile file) {
        CodeStyleSettings settings;
        if (file == null) {
            LanguageImportStatements.$$$reportNull$$$0(0);
        }
        if ((settings = CodeStyle.getSettings(file)).getExcludedFiles().contains(file)) {
            Set<ImportOptimizer> set = Collections.emptySet();
            if (set == null) {
                LanguageImportStatements.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<ImportOptimizer> optimizers = new HashSet<ImportOptimizer>();
        block0: for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            List langOptimizers = this.allForLanguage(psiFile.getLanguage());
            for (ImportOptimizer optimizer : langOptimizers) {
                if (optimizer == null || !optimizer.supports(psiFile)) continue;
                optimizers.add(optimizer);
                continue block0;
            }
        }
        HashSet<ImportOptimizer> hashSet = optimizers;
        if (hashSet == null) {
            LanguageImportStatements.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageImportStatements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

